/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.Select;
import org.apache.bcel.generic.Visitor;
import org.apache.bcel.util.ByteSequence;

public class TABLESWITCH
extends Select {
    private static final long serialVersionUID = -1178229029789923698L;

    TABLESWITCH() {
    }

    public TABLESWITCH(int[] match, InstructionHandle[] targets, InstructionHandle defaultTarget) {
        super((short)170, match, targets, defaultTarget);
        this.length = (short)(13 + this.match_length * 4);
        this.fixed_length = this.length;
    }

    @Override
    public void dump(DataOutputStream out) throws IOException {
        super.dump(out);
        int low = this.match_length > 0 ? this.match[0] : 0;
        out.writeInt(low);
        int high = this.match_length > 0 ? this.match[this.match_length - 1] : 0;
        out.writeInt(high);
        int i = 0;
        while (i < this.match_length) {
            this.indices[i] = this.getTargetOffset(this.targets[i]);
            out.writeInt(this.indices[i]);
            ++i;
        }
    }

    @Override
    protected void initFromFile(ByteSequence bytes, boolean wide) throws IOException {
        super.initFromFile(bytes, wide);
        int low = bytes.readInt();
        int high = bytes.readInt();
        this.match_length = high - low + 1;
        this.fixed_length = (short)(13 + this.match_length * 4);
        this.length = (short)(this.fixed_length + this.padding);
        this.match = new int[this.match_length];
        this.indices = new int[this.match_length];
        this.targets = new InstructionHandle[this.match_length];
        int i = 0;
        while (i < this.match_length) {
            this.match[i] = low + i;
            this.indices[i] = bytes.readInt();
            ++i;
        }
    }

    @Override
    public void accept(Visitor v) {
        v.visitVariableLengthInstruction(this);
        v.visitStackConsumer(this);
        v.visitBranchInstruction(this);
        v.visitSelect(this);
        v.visitTABLESWITCH(this);
    }
}

