/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.generic.ReferenceType;

public class ObjectType
extends ReferenceType {
    private static final long serialVersionUID = -2819379966444533294L;
    private final String class_name;
    private static final int MAX_CACHE_ENTRIES = 200;
    private static final int INITIAL_CACHE_CAPACITY = 266;
    private static HashMap<String, ObjectType> cache;

    public static synchronized ObjectType getInstance(String class_name) {
        ObjectType result;
        if (cache == null) {
            cache = new LinkedHashMap<String, ObjectType>(266, 0.75f, true){
                private static final long serialVersionUID = 2101159231109718724L;

                @Override
                protected boolean removeEldestEntry(Map.Entry<String, ObjectType> eldest) {
                    return this.size() > 200;
                }
            };
        }
        if ((result = cache.get(class_name)) != null) {
            return result;
        }
        result = new ObjectType(class_name);
        cache.put(class_name, result);
        return result;
    }

    public ObjectType(String class_name) {
        super((byte)14, "L" + class_name.replace('.', '/') + ";");
        this.class_name = class_name.replace('/', '.');
    }

    public String getClassName() {
        return this.class_name;
    }

    @Override
    public int hashCode() {
        return this.class_name.hashCode();
    }

    @Override
    public boolean equals(Object type) {
        return type instanceof ObjectType ? ((ObjectType)type).class_name.equals(this.class_name) : false;
    }

    @Deprecated
    public boolean referencesClass() {
        try {
            JavaClass jc = Repository.lookupClass(this.class_name);
            return jc.isClass();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    @Deprecated
    public boolean referencesInterface() {
        try {
            JavaClass jc = Repository.lookupClass(this.class_name);
            return !jc.isClass();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public boolean referencesClassExact() throws ClassNotFoundException {
        JavaClass jc = Repository.lookupClass(this.class_name);
        return jc.isClass();
    }

    public boolean referencesInterfaceExact() throws ClassNotFoundException {
        JavaClass jc = Repository.lookupClass(this.class_name);
        return !jc.isClass();
    }

    public boolean subclassOf(ObjectType superclass) throws ClassNotFoundException {
        if (this.referencesInterface() || superclass.referencesInterface()) {
            return false;
        }
        return Repository.instanceOf(this.class_name, superclass.class_name);
    }

    public boolean accessibleTo(ObjectType accessor) throws ClassNotFoundException {
        JavaClass jc = Repository.lookupClass(this.class_name);
        if (jc.isPublic()) {
            return true;
        }
        JavaClass acc = Repository.lookupClass(accessor.class_name);
        return acc.getPackageName().equals(jc.getPackageName());
    }
}

