/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.Stack;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.Annotations;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.ExceptionTable;
import org.apache.bcel.classfile.LineNumber;
import org.apache.bcel.classfile.LineNumberTable;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.LocalVariableTypeTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Node;
import org.apache.bcel.classfile.ParameterAnnotationEntry;
import org.apache.bcel.classfile.ParameterAnnotations;
import org.apache.bcel.classfile.RuntimeVisibleParameterAnnotations;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.generic.AnnotationEntryGen;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.ClassGenException;
import org.apache.bcel.generic.CodeExceptionGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldGenOrMethodGen;
import org.apache.bcel.generic.IINC;
import org.apache.bcel.generic.IfInstruction;
import org.apache.bcel.generic.IndexedInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.LineNumberGen;
import org.apache.bcel.generic.LocalVariableGen;
import org.apache.bcel.generic.LocalVariableInstruction;
import org.apache.bcel.generic.MethodObserver;
import org.apache.bcel.generic.NOP;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.RET;
import org.apache.bcel.generic.Select;
import org.apache.bcel.generic.TargetLostException;
import org.apache.bcel.generic.Type;
import org.apache.bcel.generic.TypedInstruction;
import org.apache.bcel.util.BCELComparator;

public class MethodGen
extends FieldGenOrMethodGen {
    private static final long serialVersionUID = -3924667713338957720L;
    private String class_name;
    private Type[] arg_types;
    private String[] arg_names;
    private int max_locals;
    private int max_stack;
    private InstructionList il;
    private boolean strip_attributes;
    private final List<LocalVariableGen> variable_vec = new ArrayList<LocalVariableGen>();
    private final List<LineNumberGen> line_number_vec = new ArrayList<LineNumberGen>();
    private final List<CodeExceptionGen> exception_vec = new ArrayList<CodeExceptionGen>();
    private final List<String> throws_vec = new ArrayList<String>();
    private final List<Attribute> code_attrs_vec = new ArrayList<Attribute>();
    private List<AnnotationEntryGen>[] param_annotations;
    private boolean hasParameterAnnotations = false;
    private boolean haveUnpackedParameterAnnotations = false;
    private static BCELComparator _cmp = new BCELComparator(){

        @Override
        public boolean equals(Object o1, Object o2) {
            MethodGen THIS = (MethodGen)o1;
            MethodGen THAT = (MethodGen)o2;
            return THIS.getName().equals(THAT.getName()) && THIS.getSignature().equals(THAT.getSignature());
        }

        @Override
        public int hashCode(Object o) {
            MethodGen THIS = (MethodGen)o;
            return THIS.getSignature().hashCode() ^ THIS.getName().hashCode();
        }
    };
    private List<MethodObserver> observers;

    public MethodGen(int access_flags, Type return_type, Type[] arg_types, String[] arg_names, String method_name, String class_name, InstructionList il, ConstantPoolGen cp) {
        this.setAccessFlags(access_flags);
        this.setType(return_type);
        this.setArgumentTypes(arg_types);
        this.setArgumentNames(arg_names);
        this.setName(method_name);
        this.setClassName(class_name);
        this.setInstructionList(il);
        this.setConstantPool(cp);
        boolean abstract_ = this.isAbstract() || this.isNative();
        InstructionHandle start = null;
        InstructionHandle end = null;
        if (!abstract_) {
            start = il.getStart();
            end = il.getEnd();
            if (!this.isStatic() && class_name != null) {
                this.addLocalVariable("this", ObjectType.getInstance(class_name), start, end);
            }
        }
        if (arg_types != null) {
            int size = arg_types.length;
            Type[] typeArray = arg_types;
            int n = arg_types.length;
            int n2 = 0;
            while (n2 < n) {
                Type arg_type = typeArray[n2];
                if (Type.VOID == arg_type) {
                    throw new ClassGenException("'void' is an illegal argument type for a method");
                }
                ++n2;
            }
            if (arg_names != null) {
                if (size != arg_names.length) {
                    throw new ClassGenException("Mismatch in argument array lengths: " + size + " vs. " + arg_names.length);
                }
            } else {
                arg_names = new String[size];
                int i = 0;
                while (i < size) {
                    arg_names[i] = "arg" + i;
                    ++i;
                }
                this.setArgumentNames(arg_names);
            }
            if (!abstract_) {
                int i = 0;
                while (i < size) {
                    this.addLocalVariable(arg_names[i], arg_types[i], start, end);
                    ++i;
                }
            }
        }
    }

    public MethodGen(Method m, String class_name, ConstantPoolGen cp) {
        this(m.getAccessFlags(), Type.getReturnType(m.getSignature()), Type.getArgumentTypes(m.getSignature()), null, m.getName(), class_name, (m.getAccessFlags() & 0x500) == 0 ? new InstructionList(m.getCode().getCode()) : null, cp);
        Attribute[] attributes;
        Attribute[] attributeArray = attributes = m.getAttributes();
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attribute = attributeArray[n2];
            Attribute a = attribute;
            if (a instanceof Code) {
                Attribute[] c_attributes;
                int n3;
                Code c = (Code)a;
                this.setMaxStack(c.getMaxStack());
                this.setMaxLocals(c.getMaxLocals());
                CodeException[] ces = c.getExceptionTable();
                if (ces != null) {
                    CodeException[] codeExceptionArray = ces;
                    n3 = ces.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        InstructionHandle end;
                        CodeException ce = codeExceptionArray[n4];
                        int type = ce.getCatchType();
                        ObjectType c_type = null;
                        if (type > 0) {
                            String cen = m.getConstantPool().getConstantString(type, (byte)7);
                            c_type = ObjectType.getInstance(cen);
                        }
                        int end_pc = ce.getEndPC();
                        int length = m.getCode().getCode().length;
                        if (length == end_pc) {
                            end = this.il.getEnd();
                        } else {
                            end = this.il.findHandle(end_pc);
                            end = end.getPrev();
                        }
                        this.addExceptionHandler(this.il.findHandle(ce.getStartPC()), end, this.il.findHandle(ce.getHandlerPC()), c_type);
                        ++n4;
                    }
                }
                Attribute[] attributeArray2 = c_attributes = c.getAttributes();
                int n5 = c_attributes.length;
                n3 = 0;
                while (n3 < n5) {
                    InstructionHandle end;
                    InstructionHandle start;
                    LocalVariable[] lv;
                    int n6;
                    Node[] nodeArray;
                    Attribute c_attribute = attributeArray2[n3];
                    a = c_attribute;
                    if (a instanceof LineNumberTable) {
                        LineNumber[] ln = ((LineNumberTable)a).getLineNumberTable();
                        nodeArray = ln;
                        int n7 = ln.length;
                        n6 = 0;
                        while (n6 < n7) {
                            Node l = nodeArray[n6];
                            InstructionHandle ih = this.il.findHandle(((LineNumber)l).getStartPC());
                            if (ih != null) {
                                this.addLineNumber(ih, ((LineNumber)l).getLineNumber());
                            }
                            ++n6;
                        }
                    } else if (a instanceof LocalVariableTable) {
                        lv = ((LocalVariableTable)a).getLocalVariableTable();
                        this.removeLocalVariables();
                        nodeArray = lv;
                        int n8 = lv.length;
                        n6 = 0;
                        while (n6 < n8) {
                            Node l = nodeArray[n6];
                            start = this.il.findHandle(((LocalVariable)l).getStartPC());
                            end = this.il.findHandle(((LocalVariable)l).getStartPC() + ((LocalVariable)l).getLength());
                            if (start == null) {
                                start = this.il.getStart();
                            }
                            if (end == null) {
                                end = this.il.getEnd();
                            }
                            this.addLocalVariable(((LocalVariable)l).getName(), Type.getType(((LocalVariable)l).getSignature()), ((LocalVariable)l).getIndex(), start, end);
                            ++n6;
                        }
                    } else if (a instanceof LocalVariableTypeTable) {
                        lv = ((LocalVariableTypeTable)a).getLocalVariableTypeTable();
                        this.removeLocalVariables();
                        nodeArray = lv;
                        int n9 = lv.length;
                        n6 = 0;
                        while (n6 < n9) {
                            Node l = nodeArray[n6];
                            start = this.il.findHandle(((LocalVariable)l).getStartPC());
                            end = this.il.findHandle(((LocalVariable)l).getStartPC() + ((LocalVariable)l).getLength());
                            if (start == null) {
                                start = this.il.getStart();
                            }
                            if (end == null) {
                                end = this.il.getEnd();
                            }
                            this.addLocalVariable(((LocalVariable)l).getName(), Type.getType(((LocalVariable)l).getSignature()), ((LocalVariable)l).getIndex(), start, end);
                            ++n6;
                        }
                    } else {
                        this.addCodeAttribute(a);
                    }
                    ++n3;
                }
            } else if (a instanceof ExceptionTable) {
                String[] names;
                String[] stringArray = names = ((ExceptionTable)a).getExceptionNames();
                int n10 = names.length;
                int c_attributes = 0;
                while (c_attributes < n10) {
                    String name2 = stringArray[c_attributes];
                    this.addException(name2);
                    ++c_attributes;
                }
            } else if (a instanceof Annotations) {
                AnnotationEntry[] aes;
                Annotations runtimeAnnotations = (Annotations)a;
                AnnotationEntry[] annotationEntryArray = aes = runtimeAnnotations.getAnnotationEntries();
                int n11 = aes.length;
                int n12 = 0;
                while (n12 < n11) {
                    AnnotationEntry element = annotationEntryArray[n12];
                    this.addAnnotationEntry(new AnnotationEntryGen(element, cp, false));
                    ++n12;
                }
            } else {
                this.addAttribute(a);
            }
            ++n2;
        }
    }

    public LocalVariableGen addLocalVariable(String name, Type type, int slot, InstructionHandle start, InstructionHandle end) {
        byte t = type.getType();
        if (t != 16) {
            LocalVariableGen l;
            int i;
            int add = type.getSize();
            if (slot + add > this.max_locals) {
                this.max_locals = slot + add;
            }
            if ((i = this.variable_vec.indexOf(l = new LocalVariableGen(slot, name, type, start, end))) >= 0) {
                this.variable_vec.set(i, l);
            } else {
                this.variable_vec.add(l);
            }
            return l;
        }
        throw new IllegalArgumentException("Can not use " + type + " as type for local variable");
    }

    public LocalVariableGen addLocalVariable(String name, Type type, InstructionHandle start, InstructionHandle end) {
        return this.addLocalVariable(name, type, this.max_locals, start, end);
    }

    public void removeLocalVariable(LocalVariableGen l) {
        this.variable_vec.remove(l);
    }

    public void removeLocalVariables() {
        this.variable_vec.clear();
    }

    public LocalVariableGen[] getLocalVariables() {
        int size = this.variable_vec.size();
        LocalVariableGen[] lg = new LocalVariableGen[size];
        this.variable_vec.toArray(lg);
        int i = 0;
        while (i < size) {
            if (lg[i].getStart() == null) {
                lg[i].setStart(this.il.getStart());
            }
            if (lg[i].getEnd() == null) {
                lg[i].setEnd(this.il.getEnd());
            }
            ++i;
        }
        if (size > 1) {
            Arrays.sort(lg, new Comparator<LocalVariableGen>(){

                @Override
                public int compare(LocalVariableGen o1, LocalVariableGen o2) {
                    return o1.getIndex() - o2.getIndex();
                }
            });
        }
        return lg;
    }

    public LocalVariableTable getLocalVariableTable(ConstantPoolGen cp) {
        LocalVariableGen[] lg = this.getLocalVariables();
        int size = lg.length;
        LocalVariable[] lv = new LocalVariable[size];
        int i = 0;
        while (i < size) {
            lv[i] = lg[i].getLocalVariable(cp);
            ++i;
        }
        return new LocalVariableTable(cp.addUtf8("LocalVariableTable"), 2 + lv.length * 10, lv, cp.getConstantPool());
    }

    public LineNumberGen addLineNumber(InstructionHandle ih, int src_line) {
        LineNumberGen l = new LineNumberGen(ih, src_line);
        this.line_number_vec.add(l);
        return l;
    }

    public void removeLineNumber(LineNumberGen l) {
        this.line_number_vec.remove(l);
    }

    public void removeLineNumbers() {
        this.line_number_vec.clear();
    }

    public LineNumberGen[] getLineNumbers() {
        LineNumberGen[] lg = new LineNumberGen[this.line_number_vec.size()];
        this.line_number_vec.toArray(lg);
        return lg;
    }

    public LineNumberTable getLineNumberTable(ConstantPoolGen cp) {
        int size = this.line_number_vec.size();
        LineNumber[] ln = new LineNumber[size];
        try {
            int i = 0;
            while (i < size) {
                ln[i] = this.line_number_vec.get(i).getLineNumber();
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        return new LineNumberTable(cp.addUtf8("LineNumberTable"), 2 + ln.length * 4, ln, cp.getConstantPool());
    }

    public CodeExceptionGen addExceptionHandler(InstructionHandle start_pc, InstructionHandle end_pc, InstructionHandle handler_pc, ObjectType catch_type) {
        if (start_pc == null || end_pc == null || handler_pc == null) {
            throw new ClassGenException("Exception handler target is null instruction");
        }
        CodeExceptionGen c = new CodeExceptionGen(start_pc, end_pc, handler_pc, catch_type);
        this.exception_vec.add(c);
        return c;
    }

    public void removeExceptionHandler(CodeExceptionGen c) {
        this.exception_vec.remove(c);
    }

    public void removeExceptionHandlers() {
        this.exception_vec.clear();
    }

    public CodeExceptionGen[] getExceptionHandlers() {
        CodeExceptionGen[] cg = new CodeExceptionGen[this.exception_vec.size()];
        this.exception_vec.toArray(cg);
        return cg;
    }

    private CodeException[] getCodeExceptions() {
        int size = this.exception_vec.size();
        CodeException[] c_exc = new CodeException[size];
        try {
            int i = 0;
            while (i < size) {
                CodeExceptionGen c = this.exception_vec.get(i);
                c_exc[i] = c.getCodeException(this.cp);
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        return c_exc;
    }

    public void addException(String class_name) {
        this.throws_vec.add(class_name);
    }

    public void removeException(String c) {
        this.throws_vec.remove(c);
    }

    public void removeExceptions() {
        this.throws_vec.clear();
    }

    public String[] getExceptions() {
        String[] e = new String[this.throws_vec.size()];
        this.throws_vec.toArray(e);
        return e;
    }

    private ExceptionTable getExceptionTable(ConstantPoolGen cp) {
        int size = this.throws_vec.size();
        int[] ex = new int[size];
        try {
            int i = 0;
            while (i < size) {
                ex[i] = cp.addClass(this.throws_vec.get(i));
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        return new ExceptionTable(cp.addUtf8("Exceptions"), 2 + 2 * size, ex, cp.getConstantPool());
    }

    public void addCodeAttribute(Attribute a) {
        this.code_attrs_vec.add(a);
    }

    public void removeCodeAttribute(Attribute a) {
        this.code_attrs_vec.remove(a);
    }

    public void removeCodeAttributes() {
        this.code_attrs_vec.clear();
    }

    public Attribute[] getCodeAttributes() {
        Attribute[] attributes = new Attribute[this.code_attrs_vec.size()];
        this.code_attrs_vec.toArray(attributes);
        return attributes;
    }

    public void addAnnotationsAsAttribute(ConstantPoolGen cp) {
        Attribute[] attrs;
        Attribute[] attributeArray = attrs = Utility.getAnnotationAttributes(cp, this.annotation_vec);
        int n = attrs.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attr = attributeArray[n2];
            this.addAttribute(attr);
            ++n2;
        }
    }

    public void addParameterAnnotationsAsAttribute(ConstantPoolGen cp) {
        if (!this.hasParameterAnnotations) {
            return;
        }
        Attribute[] attrs = Utility.getParameterAnnotationAttributes(cp, this.param_annotations);
        if (attrs != null) {
            Attribute[] attributeArray = attrs;
            int n = attrs.length;
            int n2 = 0;
            while (n2 < n) {
                Attribute attr = attributeArray[n2];
                this.addAttribute(attr);
                ++n2;
            }
        }
    }

    public Method getMethod() {
        String signature = this.getSignature();
        int name_index = this.cp.addUtf8(this.name);
        int signature_index = this.cp.addUtf8(signature);
        byte[] byte_code = null;
        if (this.il != null) {
            byte_code = this.il.getByteCode();
        }
        LineNumberTable lnt = null;
        LocalVariableTable lvt = null;
        if (this.variable_vec.size() > 0 && !this.strip_attributes) {
            lvt = this.getLocalVariableTable(this.cp);
            this.addCodeAttribute(lvt);
        }
        if (this.line_number_vec.size() > 0 && !this.strip_attributes) {
            lnt = this.getLineNumberTable(this.cp);
            this.addCodeAttribute(lnt);
        }
        Attribute[] code_attrs = this.getCodeAttributes();
        int attrs_len = 0;
        Attribute[] attributeArray = code_attrs;
        int n = code_attrs.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute code_attr = attributeArray[n2];
            attrs_len += code_attr.getLength() + 6;
            ++n2;
        }
        CodeException[] c_exc = this.getCodeExceptions();
        int exc_len = c_exc.length * 8;
        Code code = null;
        if (this.il != null && !this.isAbstract() && !this.isNative()) {
            Attribute[] attributes;
            Attribute[] attributeArray2 = attributes = this.getAttributes();
            int n3 = attributes.length;
            int n4 = 0;
            while (n4 < n3) {
                Attribute a = attributeArray2[n4];
                if (a instanceof Code) {
                    this.removeAttribute(a);
                }
                ++n4;
            }
            code = new Code(this.cp.addUtf8("Code"), 8 + byte_code.length + 2 + exc_len + 2 + attrs_len, this.max_stack, this.max_locals, byte_code, c_exc, code_attrs, this.cp.getConstantPool());
            this.addAttribute(code);
        }
        this.addAnnotationsAsAttribute(this.cp);
        this.addParameterAnnotationsAsAttribute(this.cp);
        ExceptionTable et = null;
        if (this.throws_vec.size() > 0) {
            et = this.getExceptionTable(this.cp);
            this.addAttribute(et);
        }
        Method m = new Method(this.access_flags, name_index, signature_index, this.getAttributes(), this.cp.getConstantPool());
        if (lvt != null) {
            this.removeCodeAttribute(lvt);
        }
        if (lnt != null) {
            this.removeCodeAttribute(lnt);
        }
        if (code != null) {
            this.removeAttribute(code);
        }
        if (et != null) {
            this.removeAttribute(et);
        }
        return m;
    }

    /*
     * Unable to fully structure code
     */
    public void removeNOPs() {
        if (this.il != null) {
            ih = this.il.getStart();
            while (ih != null) {
                block7: {
                    next = ih.next;
                    if (next != null && ih.getInstruction() instanceof NOP) {
                        try {
                            this.il.delete(ih);
                            break block7;
                        }
                        catch (TargetLostException e) {
                            var8_8 = targets = e.getTargets();
                            var7_7 = targets.length;
                            var6_6 = 0;
                            ** while (var6_6 < var7_7)
                        }
lbl-1000:
                        // 1 sources

                        {
                            target = var8_8[var6_6];
                            var13_13 = targeters = target.getTargeters();
                            var12_12 = targeters.length;
                            var11_11 = 0;
                            while (var11_11 < var12_12) {
                                targeter = var13_13[var11_11];
                                targeter.updateTarget(target, next);
                                ++var11_11;
                            }
                            ++var6_6;
                            continue;
                        }
                    }
                }
                ih = next;
            }
        }
    }

    public void setMaxLocals(int m) {
        this.max_locals = m;
    }

    public int getMaxLocals() {
        return this.max_locals;
    }

    public void setMaxStack(int m) {
        this.max_stack = m;
    }

    public int getMaxStack() {
        return this.max_stack;
    }

    public String getClassName() {
        return this.class_name;
    }

    public void setClassName(String class_name) {
        this.class_name = class_name;
    }

    public void setReturnType(Type return_type) {
        this.setType(return_type);
    }

    public Type getReturnType() {
        return this.getType();
    }

    public void setArgumentTypes(Type[] arg_types) {
        this.arg_types = arg_types;
    }

    public Type[] getArgumentTypes() {
        return (Type[])this.arg_types.clone();
    }

    public void setArgumentType(int i, Type type) {
        this.arg_types[i] = type;
    }

    public Type getArgumentType(int i) {
        return this.arg_types[i];
    }

    public void setArgumentNames(String[] arg_names) {
        this.arg_names = arg_names;
    }

    public String[] getArgumentNames() {
        return (String[])this.arg_names.clone();
    }

    public void setArgumentName(int i, String name) {
        this.arg_names[i] = name;
    }

    public String getArgumentName(int i) {
        return this.arg_names[i];
    }

    public InstructionList getInstructionList() {
        return this.il;
    }

    public void setInstructionList(InstructionList il) {
        this.il = il;
    }

    @Override
    public String getSignature() {
        return Type.getMethodSignature(this.type, this.arg_types);
    }

    public void setMaxStack() {
        this.max_stack = this.il != null ? MethodGen.getMaxStack(this.cp, this.il, this.getExceptionHandlers()) : 0;
    }

    public void setMaxLocals() {
        if (this.il != null) {
            int max;
            int n = max = this.isStatic() ? 0 : 1;
            if (this.arg_types != null) {
                Type[] typeArray = this.arg_types;
                int n2 = this.arg_types.length;
                int n3 = 0;
                while (n3 < n2) {
                    Type arg_type = typeArray[n3];
                    max += arg_type.getSize();
                    ++n3;
                }
            }
            InstructionHandle ih = this.il.getStart();
            while (ih != null) {
                int index;
                Instruction ins = ih.getInstruction();
                if ((ins instanceof LocalVariableInstruction || ins instanceof RET || ins instanceof IINC) && (index = ((IndexedInstruction)((Object)ins)).getIndex() + ((TypedInstruction)((Object)ins)).getType(this.cp).getSize()) > max) {
                    max = index;
                }
                ih = ih.getNext();
            }
            this.max_locals = max;
        } else {
            this.max_locals = 0;
        }
    }

    public void stripAttributes(boolean flag) {
        this.strip_attributes = flag;
    }

    public static int getMaxStack(ConstantPoolGen cp, InstructionList il, CodeExceptionGen[] et) {
        BranchStack branchTargets = new BranchStack();
        CodeExceptionGen[] codeExceptionGenArray = et;
        int n = et.length;
        int n2 = 0;
        while (n2 < n) {
            CodeExceptionGen element = codeExceptionGenArray[n2];
            InstructionHandle handler_pc = element.getHandlerPC();
            if (handler_pc != null) {
                branchTargets.push(handler_pc, 1);
            }
            ++n2;
        }
        int stackDepth = 0;
        int maxStackDepth = 0;
        InstructionHandle ih = il.getStart();
        while (ih != null) {
            BranchTarget bt;
            Instruction instruction = ih.getInstruction();
            short opcode = instruction.getOpcode();
            int delta = instruction.produceStack(cp) - instruction.consumeStack(cp);
            if ((stackDepth += delta) > maxStackDepth) {
                maxStackDepth = stackDepth;
            }
            if (instruction instanceof BranchInstruction) {
                BranchInstruction branch = (BranchInstruction)instruction;
                if (instruction instanceof Select) {
                    InstructionHandle[] targets;
                    Select select = (Select)branch;
                    InstructionHandle[] instructionHandleArray = targets = select.getTargets();
                    int n3 = targets.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        InstructionHandle target = instructionHandleArray[n4];
                        branchTargets.push(target, stackDepth);
                        ++n4;
                    }
                    ih = null;
                } else if (!(branch instanceof IfInstruction)) {
                    if (opcode == 168 || opcode == 201) {
                        branchTargets.push(ih.getNext(), stackDepth - 1);
                    }
                    ih = null;
                }
                branchTargets.push(branch.getTarget(), stackDepth);
            } else if (opcode == 191 || opcode == 169 || opcode >= 172 && opcode <= 177) {
                ih = null;
            }
            if (ih != null) {
                ih = ih.getNext();
            }
            if (ih != null || (bt = branchTargets.pop()) == null) continue;
            ih = bt.target;
            stackDepth = bt.stackDepth;
        }
        return maxStackDepth;
    }

    public void addObserver(MethodObserver o) {
        if (this.observers == null) {
            this.observers = new ArrayList<MethodObserver>();
        }
        this.observers.add(o);
    }

    public void removeObserver(MethodObserver o) {
        if (this.observers != null) {
            this.observers.remove(o);
        }
    }

    public void update() {
        if (this.observers != null) {
            for (MethodObserver observer : this.observers) {
                observer.notify(this);
            }
        }
    }

    public final String toString() {
        String access = Utility.accessToString(this.access_flags);
        String signature = Type.getMethodSignature(this.type, this.arg_types);
        signature = Utility.methodSignatureToString(signature, this.name, access, true, this.getLocalVariableTable(this.cp));
        StringBuilder buf = new StringBuilder(signature);
        int i = 0;
        while (i < this.getAttributes().length) {
            Attribute a = this.getAttributes()[i];
            if (!(a instanceof Code) && !(a instanceof ExceptionTable)) {
                buf.append(" [").append(a.toString()).append("]");
            }
            ++i;
        }
        if (this.throws_vec.size() > 0) {
            for (String throwsDescriptor : this.throws_vec) {
                buf.append("\n\t\tthrows ").append(throwsDescriptor);
            }
        }
        return buf.toString();
    }

    public MethodGen copy(String class_name, ConstantPoolGen cp) {
        Method m = ((MethodGen)this.clone()).getMethod();
        MethodGen mg = new MethodGen(m, class_name, this.cp);
        if (this.cp != cp) {
            mg.setConstantPool(cp);
            mg.getInstructionList().replaceConstantPool(this.cp, cp);
        }
        return mg;
    }

    public List<AnnotationEntryGen> getAnnotationsOnParameter(int i) {
        this.ensureExistingParameterAnnotationsUnpacked();
        if (!this.hasParameterAnnotations || i > this.arg_types.length) {
            return null;
        }
        return this.param_annotations[i];
    }

    private void ensureExistingParameterAnnotationsUnpacked() {
        if (this.haveUnpackedParameterAnnotations) {
            return;
        }
        Attribute[] attrs = this.getAttributes();
        ParameterAnnotations paramAnnVisAttr = null;
        ParameterAnnotations paramAnnInvisAttr = null;
        Attribute[] attributeArray = attrs;
        int n = attrs.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attribute = attributeArray[n2];
            if (attribute instanceof ParameterAnnotations) {
                if (!this.hasParameterAnnotations) {
                    this.param_annotations = new List[this.arg_types.length];
                    int j = 0;
                    while (j < this.arg_types.length) {
                        this.param_annotations[j] = new ArrayList<AnnotationEntryGen>();
                        ++j;
                    }
                }
                this.hasParameterAnnotations = true;
                ParameterAnnotations rpa = (ParameterAnnotations)attribute;
                if (rpa instanceof RuntimeVisibleParameterAnnotations) {
                    paramAnnVisAttr = rpa;
                } else {
                    paramAnnInvisAttr = rpa;
                }
                int j = 0;
                while (j < this.arg_types.length) {
                    ParameterAnnotationEntry immutableArray = rpa.getParameterAnnotationEntries()[j];
                    List<AnnotationEntryGen> mutable = this.makeMutableVersion(immutableArray.getAnnotationEntries());
                    this.param_annotations[j].addAll(mutable);
                    ++j;
                }
            }
            ++n2;
        }
        if (paramAnnVisAttr != null) {
            this.removeAttribute(paramAnnVisAttr);
        }
        if (paramAnnInvisAttr != null) {
            this.removeAttribute(paramAnnInvisAttr);
        }
        this.haveUnpackedParameterAnnotations = true;
    }

    private List<AnnotationEntryGen> makeMutableVersion(AnnotationEntry[] mutableArray) {
        ArrayList<AnnotationEntryGen> result = new ArrayList<AnnotationEntryGen>();
        AnnotationEntry[] annotationEntryArray = mutableArray;
        int n = mutableArray.length;
        int n2 = 0;
        while (n2 < n) {
            AnnotationEntry element = annotationEntryArray[n2];
            result.add(new AnnotationEntryGen(element, this.getConstantPool(), false));
            ++n2;
        }
        return result;
    }

    public void addParameterAnnotation(int parameterIndex, AnnotationEntryGen annotation) {
        List<AnnotationEntryGen> existingAnnotations;
        this.ensureExistingParameterAnnotationsUnpacked();
        if (!this.hasParameterAnnotations) {
            this.param_annotations = new List[this.arg_types.length];
            this.hasParameterAnnotations = true;
        }
        if ((existingAnnotations = this.param_annotations[parameterIndex]) != null) {
            existingAnnotations.add(annotation);
        } else {
            ArrayList<AnnotationEntryGen> l = new ArrayList<AnnotationEntryGen>();
            l.add(annotation);
            this.param_annotations[parameterIndex] = l;
        }
    }

    public static BCELComparator getComparator() {
        return _cmp;
    }

    public static void setComparator(BCELComparator comparator) {
        _cmp = comparator;
    }

    public boolean equals(Object obj) {
        return _cmp.equals(this, obj);
    }

    public int hashCode() {
        return _cmp.hashCode(this);
    }

    static final class BranchStack {
        Stack<BranchTarget> branchTargets = new Stack();
        Hashtable<InstructionHandle, BranchTarget> visitedTargets = new Hashtable();

        BranchStack() {
        }

        public void push(InstructionHandle target, int stackDepth) {
            if (this.visited(target)) {
                return;
            }
            this.branchTargets.push(this.visit(target, stackDepth));
        }

        public BranchTarget pop() {
            if (!this.branchTargets.empty()) {
                BranchTarget bt = this.branchTargets.pop();
                return bt;
            }
            return null;
        }

        private BranchTarget visit(InstructionHandle target, int stackDepth) {
            BranchTarget bt = new BranchTarget(target, stackDepth);
            this.visitedTargets.put(target, bt);
            return bt;
        }

        private boolean visited(InstructionHandle target) {
            return this.visitedTargets.get(target) != null;
        }
    }

    static final class BranchTarget {
        InstructionHandle target;
        int stackDepth;

        BranchTarget(InstructionHandle target, int stackDepth) {
            this.target = target;
            this.stackDepth = stackDepth;
        }
    }
}

