/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.bcel.Constants;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Node;
import org.apache.bcel.classfile.ParameterAnnotations;
import org.apache.bcel.classfile.Visitor;

public class ParameterAnnotationEntry
implements Node,
Constants {
    private final int annotation_table_length;
    private final AnnotationEntry[] annotation_table;

    ParameterAnnotationEntry(DataInputStream file, ConstantPool constant_pool) throws IOException {
        this.annotation_table_length = file.readUnsignedShort();
        this.annotation_table = new AnnotationEntry[this.annotation_table_length];
        int i = 0;
        while (i < this.annotation_table_length) {
            this.annotation_table[i] = AnnotationEntry.read(file, constant_pool, false);
            ++i;
        }
    }

    @Override
    public void accept(Visitor v) {
    }

    public final int getNumAnnotations() {
        return this.annotation_table_length;
    }

    public AnnotationEntry[] getAnnotationEntries() {
        return this.annotation_table;
    }

    public void dump(DataOutputStream dos) throws IOException {
        dos.writeShort(this.annotation_table_length);
        int i = 0;
        while (i < this.annotation_table_length) {
            this.annotation_table[i].dump(dos);
            ++i;
        }
    }

    public static ParameterAnnotationEntry[] createParameterAnnotationEntries(Attribute[] attrs) {
        ArrayList accumulatedAnnotations = new ArrayList(attrs.length);
        Attribute[] attributeArray = attrs;
        int n = attrs.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attribute = attributeArray[n2];
            if (attribute instanceof ParameterAnnotations) {
                ParameterAnnotations runtimeAnnotations = (ParameterAnnotations)attribute;
                Collections.addAll(accumulatedAnnotations, runtimeAnnotations.getParameterAnnotationEntries());
            }
            ++n2;
        }
        return accumulatedAnnotations.toArray(new ParameterAnnotationEntry[accumulatedAnnotations.size()]);
    }
}

