/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.MethodParameter;
import org.apache.bcel.classfile.Visitor;

public class MethodParameters
extends Attribute {
    private static final long serialVersionUID = 2500272580422360140L;
    private MethodParameter[] parameters = new MethodParameter[0];

    MethodParameters(int name_index, int length, DataInputStream file, ConstantPool constant_pool) throws IOException {
        super((byte)21, name_index, length, constant_pool);
        System.out.println("new MethodParameters");
        int parameters_count = file.readUnsignedByte();
        this.parameters = new MethodParameter[parameters_count];
        int i = 0;
        while (i < parameters_count) {
            this.parameters[i] = new MethodParameter(file);
            ++i;
        }
    }

    public MethodParameter[] getParameters() {
        return this.parameters;
    }

    public void setParameters(MethodParameter[] parameters) {
        this.parameters = parameters;
    }

    @Override
    public void accept(Visitor v) {
        v.visitMethodParameters(this);
    }

    @Override
    public Attribute copy(ConstantPool _constant_pool) {
        MethodParameters c = (MethodParameters)this.clone();
        c.parameters = new MethodParameter[this.parameters.length];
        int i = 0;
        while (i < this.parameters.length) {
            c.parameters[i] = this.parameters[i].copy();
            ++i;
        }
        c.constant_pool = _constant_pool;
        return c;
    }

    @Override
    public void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeByte(this.parameters.length);
        MethodParameter[] methodParameterArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            MethodParameter parameter = methodParameterArray[n2];
            parameter.dump(file);
            ++n2;
        }
    }
}

