/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.Visitor;

public class LocalVariableTypeTable
extends Attribute {
    private static final long serialVersionUID = -1082157891095177114L;
    private int local_variable_type_table_length;
    private LocalVariable[] local_variable_type_table;

    public LocalVariableTypeTable(LocalVariableTypeTable c) {
        this(c.getNameIndex(), c.getLength(), c.getLocalVariableTypeTable(), c.getConstantPool());
    }

    public LocalVariableTypeTable(int name_index, int length, LocalVariable[] local_variable_table, ConstantPool constant_pool) {
        super((byte)17, name_index, length, constant_pool);
        this.setLocalVariableTable(local_variable_table);
    }

    LocalVariableTypeTable(int nameIdx, int len, DataInputStream dis, ConstantPool cpool) throws IOException {
        this(nameIdx, len, (LocalVariable[])null, cpool);
        this.local_variable_type_table_length = dis.readUnsignedShort();
        this.local_variable_type_table = new LocalVariable[this.local_variable_type_table_length];
        int i = 0;
        while (i < this.local_variable_type_table_length) {
            this.local_variable_type_table[i] = new LocalVariable(dis, cpool);
            ++i;
        }
    }

    @Override
    public void accept(Visitor v) {
        v.visitLocalVariableTypeTable(this);
    }

    @Override
    public final void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeShort(this.local_variable_type_table_length);
        int i = 0;
        while (i < this.local_variable_type_table_length) {
            this.local_variable_type_table[i].dump(file);
            ++i;
        }
    }

    public final LocalVariable[] getLocalVariableTypeTable() {
        return this.local_variable_type_table;
    }

    public final LocalVariable getLocalVariable(int index) {
        int i = 0;
        while (i < this.local_variable_type_table_length) {
            if (this.local_variable_type_table[i].getIndex() == index) {
                return this.local_variable_type_table[i];
            }
            ++i;
        }
        return null;
    }

    public final void setLocalVariableTable(LocalVariable[] local_variable_table) {
        this.local_variable_type_table = local_variable_table;
        this.local_variable_type_table_length = local_variable_table == null ? 0 : local_variable_table.length;
    }

    @Override
    public final String toString() {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < this.local_variable_type_table_length) {
            buf.append(this.local_variable_type_table[i].toString());
            if (i < this.local_variable_type_table_length - 1) {
                buf.append('\n');
            }
            ++i;
        }
        return buf.toString();
    }

    @Override
    public Attribute copy(ConstantPool constant_pool) {
        LocalVariableTypeTable c = (LocalVariableTypeTable)this.clone();
        c.local_variable_type_table = new LocalVariable[this.local_variable_type_table_length];
        int i = 0;
        while (i < this.local_variable_type_table_length) {
            c.local_variable_type_table[i] = this.local_variable_type_table[i].copy();
            ++i;
        }
        c.constant_pool = constant_pool;
        return c;
    }

    public final int getTableLength() {
        return this.local_variable_type_table_length;
    }
}

