/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import org.apache.bcel.classfile.Node;
import org.apache.bcel.classfile.Visitor;

public final class LineNumber
implements Cloneable,
Node,
Serializable {
    private static final long serialVersionUID = 169537400672820016L;
    private short start_pc;
    private short line_number;

    public LineNumber(LineNumber c) {
        this(c.getStartPC(), c.getLineNumber());
    }

    LineNumber(DataInput file) throws IOException {
        this(file.readUnsignedShort(), file.readUnsignedShort());
    }

    public LineNumber(int start_pc, int line_number) {
        this.start_pc = (short)start_pc;
        this.line_number = (short)line_number;
    }

    @Override
    public void accept(Visitor v) {
        v.visitLineNumber(this);
    }

    public final void dump(DataOutputStream file) throws IOException {
        file.writeShort(this.start_pc);
        file.writeShort(this.line_number);
    }

    public final int getLineNumber() {
        return 0xFFFF & this.line_number;
    }

    public final int getStartPC() {
        return 0xFFFF & this.start_pc;
    }

    public final void setLineNumber(int line_number) {
        this.line_number = (short)line_number;
    }

    public final void setStartPC(int start_pc) {
        this.start_pc = (short)start_pc;
    }

    public final String toString() {
        return "LineNumber(" + this.start_pc + ", " + this.line_number + ")";
    }

    public LineNumber copy() {
        try {
            return (LineNumber)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

