/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.classfile.Visitor;

public final class ConstantUtf8
extends Constant {
    private static final long serialVersionUID = -8709101585611518985L;
    private final String bytes;
    private static final int MAX_CACHE_ENTRIES = 20000;
    private static final int INITIAL_CACHE_CAPACITY = 26666;
    private static HashMap<String, ConstantUtf8> cache;
    private static int considered;
    private static int hits;
    private static int skipped;
    private static int created;
    static final boolean BCEL_STATISTICS;
    static final boolean BCEL_DONT_CACHE;

    static {
        considered = 0;
        hits = 0;
        skipped = 0;
        created = 0;
        BCEL_STATISTICS = Boolean.getBoolean("bcel.statistics");
        BCEL_DONT_CACHE = Boolean.getBoolean("bcel.dontCache");
        if (BCEL_STATISTICS) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    System.err.println("Cache hit " + hits + "/" + considered + ", " + skipped + " skipped");
                    System.err.println("Total of " + created + " ConstantUtf8 objects created");
                }
            });
        }
    }

    public static synchronized ConstantUtf8 getCachedInstance(String s) {
        ConstantUtf8 result;
        if (BCEL_DONT_CACHE || s.length() > 200) {
            ++skipped;
            return new ConstantUtf8(s);
        }
        ++considered;
        if (cache == null) {
            cache = new LinkedHashMap<String, ConstantUtf8>(26666, 0.75f, true){
                private static final long serialVersionUID = -8506975356158971766L;

                @Override
                protected boolean removeEldestEntry(Map.Entry<String, ConstantUtf8> eldest) {
                    return this.size() > 20000;
                }
            };
        }
        if ((result = cache.get(s)) != null) {
            ++hits;
            return result;
        }
        result = new ConstantUtf8(s);
        cache.put(s, result);
        return result;
    }

    public static ConstantUtf8 getInstance(String s) {
        return ConstantUtf8.getCachedInstance(s);
    }

    public static ConstantUtf8 getInstance(DataInputStream file) throws IOException {
        return ConstantUtf8.getInstance(file.readUTF());
    }

    public ConstantUtf8(ConstantUtf8 c) {
        this(c.getBytes());
    }

    ConstantUtf8(DataInput file) throws IOException {
        super((byte)1);
        this.bytes = file.readUTF();
        ++created;
    }

    public ConstantUtf8(String bytes) {
        super((byte)1);
        if (bytes == null) {
            throw new IllegalArgumentException("bytes must not be null!");
        }
        this.bytes = bytes;
        ++created;
    }

    @Override
    public void accept(Visitor v) {
        v.visitConstantUtf8(this);
    }

    @Override
    public final void dump(DataOutputStream file) throws IOException {
        file.writeByte(this.tag);
        file.writeUTF(this.bytes);
    }

    public final String getBytes() {
        return this.bytes;
    }

    @Deprecated
    public final void setBytes(String bytes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final String toString() {
        return String.valueOf(super.toString()) + "(\"" + Utility.replace(this.bytes, "\n", "\\n") + "\")";
    }
}

