/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantObject;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Visitor;

public final class ConstantDouble
extends Constant
implements ConstantObject {
    private static final long serialVersionUID = -7394764537394782136L;
    private double bytes;

    public ConstantDouble(double bytes) {
        super((byte)6);
        this.bytes = bytes;
    }

    public ConstantDouble(ConstantDouble c) {
        this(c.getBytes());
    }

    ConstantDouble(DataInput file) throws IOException {
        this(file.readDouble());
    }

    @Override
    public void accept(Visitor v) {
        v.visitConstantDouble(this);
    }

    @Override
    public final void dump(DataOutputStream file) throws IOException {
        file.writeByte(this.tag);
        file.writeDouble(this.bytes);
    }

    public final double getBytes() {
        return this.bytes;
    }

    public final void setBytes(double bytes) {
        this.bytes = bytes;
    }

    @Override
    public final String toString() {
        return String.valueOf(super.toString()) + "(bytes = " + this.bytes + ")";
    }

    @Override
    public Object getConstantValue(ConstantPool cp) {
        return new Double(this.bytes);
    }
}

