/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.LineNumberTable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.classfile.Visitor;

public final class Code
extends Attribute {
    private static final long serialVersionUID = -432884354459701506L;
    private int max_stack;
    private int max_locals;
    private int code_length;
    private byte[] code;
    private int exception_table_length;
    private CodeException[] exception_table;
    private int attributes_count;
    private Attribute[] attributes;

    public Code(Code c) {
        this(c.getNameIndex(), c.getLength(), c.getMaxStack(), c.getMaxLocals(), c.getCode(), c.getExceptionTable(), c.getAttributes(), c.getConstantPool());
    }

    Code(int name_index, int length, DataInputStream file, ConstantPool constant_pool) throws IOException {
        this(name_index, length, file.readUnsignedShort(), file.readUnsignedShort(), null, null, null, constant_pool);
        this.code_length = file.readInt();
        this.code = new byte[this.code_length];
        file.readFully(this.code);
        this.exception_table_length = file.readUnsignedShort();
        this.exception_table = new CodeException[this.exception_table_length];
        int i = 0;
        while (i < this.exception_table_length) {
            this.exception_table[i] = new CodeException(file);
            ++i;
        }
        this.attributes_count = file.readUnsignedShort();
        this.attributes = new Attribute[this.attributes_count];
        i = 0;
        while (i < this.attributes_count) {
            this.attributes[i] = Attribute.readAttribute(file, constant_pool);
            ++i;
        }
        this.length = length;
    }

    public Code(int name_index, int length, int max_stack, int max_locals, byte[] code, CodeException[] exception_table, Attribute[] attributes, ConstantPool constant_pool) {
        super((byte)2, name_index, length, constant_pool);
        this.max_stack = max_stack;
        this.max_locals = max_locals;
        this.setCode(code);
        this.setExceptionTable(exception_table);
        this.setAttributes(attributes);
    }

    @Override
    public void accept(Visitor v) {
        v.visitCode(this);
    }

    @Override
    public final void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeShort(this.max_stack);
        file.writeShort(this.max_locals);
        file.writeInt(this.code_length);
        file.write(this.code, 0, this.code_length);
        file.writeShort(this.exception_table_length);
        int i = 0;
        while (i < this.exception_table_length) {
            this.exception_table[i].dump(file);
            ++i;
        }
        file.writeShort(this.attributes_count);
        i = 0;
        while (i < this.attributes_count) {
            this.attributes[i].dump(file);
            ++i;
        }
    }

    public final Attribute[] getAttributes() {
        return this.attributes;
    }

    public LineNumberTable getLineNumberTable() {
        int i = 0;
        while (i < this.attributes_count) {
            if (this.attributes[i] instanceof LineNumberTable) {
                return (LineNumberTable)this.attributes[i];
            }
            ++i;
        }
        return null;
    }

    public LocalVariableTable getLocalVariableTable() {
        int i = 0;
        while (i < this.attributes_count) {
            if (this.attributes[i] instanceof LocalVariableTable) {
                return (LocalVariableTable)this.attributes[i];
            }
            ++i;
        }
        return null;
    }

    public final byte[] getCode() {
        return this.code;
    }

    public final CodeException[] getExceptionTable() {
        return this.exception_table;
    }

    public final int getMaxLocals() {
        return this.max_locals;
    }

    public final int getMaxStack() {
        return this.max_stack;
    }

    private int getInternalLength() {
        return 8 + this.code_length + 2 + 8 * this.exception_table_length + 2;
    }

    private int calculateLength() {
        int len = 0;
        int i = 0;
        while (i < this.attributes_count) {
            len += this.attributes[i].length + 6;
            ++i;
        }
        return len + this.getInternalLength();
    }

    public final void setAttributes(Attribute[] attributes) {
        this.attributes = attributes;
        this.attributes_count = attributes == null ? 0 : attributes.length;
        this.length = this.calculateLength();
    }

    public final void setCode(byte[] code) {
        this.code = code;
        this.code_length = code == null ? 0 : code.length;
        this.length = this.calculateLength();
    }

    public final void setExceptionTable(CodeException[] exception_table) {
        this.exception_table = exception_table;
        this.exception_table_length = exception_table == null ? 0 : exception_table.length;
        this.length = this.calculateLength();
    }

    public final void setMaxLocals(int max_locals) {
        this.max_locals = max_locals;
    }

    public final void setMaxStack(int max_stack) {
        this.max_stack = max_stack;
    }

    public final String toString(boolean verbose) {
        int i;
        StringBuilder buf = new StringBuilder(100);
        buf.append("Code(max_stack = ").append(this.max_stack).append(", max_locals = ").append(this.max_locals).append(", code_length = ").append(this.code_length).append(")\n").append(Utility.codeToString(this.code, this.constant_pool, 0, -1, verbose));
        if (this.exception_table_length > 0) {
            buf.append("\nException handler(s) = \n").append("From\tTo\tHandler\tType\n");
            i = 0;
            while (i < this.exception_table_length) {
                buf.append(this.exception_table[i].toString(this.constant_pool, verbose)).append("\n");
                ++i;
            }
        }
        if (this.attributes_count > 0) {
            buf.append("\nAttribute(s) = \n");
            i = 0;
            while (i < this.attributes_count) {
                buf.append(this.attributes[i].toString()).append("\n");
                ++i;
            }
        }
        return buf.toString();
    }

    @Override
    public final String toString() {
        return this.toString(true);
    }

    @Override
    public Attribute copy(ConstantPool _constant_pool) {
        Code c = (Code)this.clone();
        if (this.code != null) {
            c.code = new byte[this.code.length];
            System.arraycopy(this.code, 0, c.code, 0, this.code.length);
        }
        c.constant_pool = _constant_pool;
        c.exception_table = new CodeException[this.exception_table_length];
        int i = 0;
        while (i < this.exception_table_length) {
            c.exception_table[i] = this.exception_table[i].copy();
            ++i;
        }
        c.attributes = new Attribute[this.attributes_count];
        i = 0;
        while (i < this.attributes_count) {
            c.attributes[i] = this.attributes[i].copy(_constant_pool);
            ++i;
        }
        return c;
    }
}

