/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import org.apache.bcel.classfile.ClassFormatException;

public class BootstrapMethod
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -4517534834047695344L;
    private int bootstrap_method_ref;
    private int[] bootstrap_arguments;

    public BootstrapMethod() {
    }

    BootstrapMethod(DataInputStream file) throws IOException, ClassFormatException {
        this.bootstrap_method_ref = file.readUnsignedShort();
        int num_bootstrap_methods = file.readUnsignedShort();
        this.bootstrap_arguments = new int[num_bootstrap_methods];
        int i = 0;
        while (i < num_bootstrap_methods) {
            this.bootstrap_arguments[i] = file.readUnsignedShort();
            ++i;
        }
    }

    public int getBootstrapMethodRef() {
        return this.bootstrap_method_ref;
    }

    public void setBootstrapMethodRef(int bootstrap_method_ref) {
        this.bootstrap_method_ref = bootstrap_method_ref;
    }

    public int[] getBootstrapArguments() {
        return this.bootstrap_arguments;
    }

    public void setBootstrapArguments(int[] bootstrap_arguments) {
        this.bootstrap_arguments = bootstrap_arguments;
    }

    public final void dump(DataOutputStream file) throws IOException {
        file.writeShort(this.bootstrap_method_ref);
        file.writeShort(this.bootstrap_arguments.length);
        int[] nArray = this.bootstrap_arguments;
        int n = this.bootstrap_arguments.length;
        int n2 = 0;
        while (n2 < n) {
            int bootstrap_argument = nArray[n2];
            file.writeShort(bootstrap_argument);
            ++n2;
        }
    }

    public BootstrapMethod copy() {
        try {
            return (BootstrapMethod)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

