/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.microui.extension;

import com.is2t.microej.workbench.extension.Page;
import com.is2t.microej.workbench.extension.PagesResolver;
import com.is2t.microej.workbench.std.launch.ext.ComboOption;
import com.is2t.microej.workbench.std.launch.ext.Description;
import com.is2t.microej.workbench.std.launch.ext.Group;
import com.is2t.microej.workbench.std.launch.ext.ILabel;
import com.is2t.microej.workbench.std.launch.ext.LabelGroup;
import com.is2t.microej.workbench.std.launch.ext.OptionValidator;
import com.is2t.microej.workbench.std.launch.ext.PageContent;
import com.is2t.microej.workbench.std.launch.ext.StringLabel;
import com.is2t.microej.workbench.std.launch.ext.TextFieldOption;
import com.is2t.microej.workbench.std.launch.ext.XHTMLDescription;
import com.is2t.microej.workbench.std.launch.ext.expr.Expression;
import com.is2t.microej.workbench.std.launch.ext.validator.UIntBoundOptionValidator;
import com.is2t.microej.workbench.std.launch.ext.validator.UIntOptionValidator;
import com.is2t.microui.extension.LibPage;
import com.is2t.microui.extension.MicroUIMessages;
import java.util.Properties;

public class MicroUIPage
implements Page {
    private static final String NBEVENTS_PROPERTY = "ej.microui.memory.queue.size";
    private static final String PRIORITY_PROPERTY = "com.microej.library.microui.pump.priority";
    private static final String WORKINGBUFFER_PROPERTY = "ej.microui.memory.imagesheap.size";
    private static final String DEFAULT_VALUE_FILE = "/memories.properties";
    private static final String DEFAULT_VALUE_PREFIX = "workbenchExtension.memory.default.";
    private static final int NBEVENTS_DEFAULT = 100;
    private static final int WORKINGBUFFER_DEFAULT = 131072;
    private final Properties memoriesProperties = new Properties();

    public MicroUIPage() {
        try {
            this.memoriesProperties.load(this.getClass().getResourceAsStream(DEFAULT_VALUE_FILE));
        }
        catch (Exception exception) {}
    }

    public String getParent() {
        return LibPage.class.getName();
    }

    public String getName() {
        return MicroUIMessages.CategoryMicroUI;
    }

    public PageContent getContent() {
        return new Group(new PageContent[]{this.getMemoryGroup()}, 1);
    }

    private PageContent getMemoryGroup() {
        TextFieldOption textFieldOption = new TextFieldOption((ILabel)new StringLabel(MicroUIMessages.MUILabelNumberOfEvents), NBEVENTS_PROPERTY);
        textFieldOption.setOptionValidator((OptionValidator)new UIntBoundOptionValidator(MicroUIMessages.MUILabelNumberOfEvents, 50L, false));
        textFieldOption.setInitialValue(Integer.toString(this.getDefaultValue(NBEVENTS_PROPERTY, 100)));
        textFieldOption.setDescription((Description)new XHTMLDescription(MicroUIMessages.MicroUIDescEvents));
        String[] stringArray = new String[10];
        int n = 1;
        while (n <= 10) {
            stringArray[n - 1] = String.valueOf(n);
            ++n;
        }
        ComboOption comboOption = new ComboOption((ILabel)new StringLabel(MicroUIMessages.MUILabelPriority), PRIORITY_PROPERTY, stringArray);
        comboOption.setInitialValue(4);
        comboOption.setDescription((Description)new XHTMLDescription(MicroUIMessages.MicroUIDescPriority));
        TextFieldOption textFieldOption2 = new TextFieldOption((ILabel)new StringLabel(MicroUIMessages.MUILabelWorkingBufferSize), WORKINGBUFFER_PROPERTY);
        textFieldOption2.setOptionValidator((OptionValidator)new UIntOptionValidator(MicroUIMessages.MUILabelWorkingBufferSize));
        textFieldOption2.setInitialValue(Integer.toString(this.getDefaultValue(WORKINGBUFFER_PROPERTY, 131072)));
        textFieldOption2.setDescription((Description)new XHTMLDescription(MicroUIMessages.MicroUIDescWorkingBuffer));
        return new LabelGroup(MicroUIMessages.MUILabelMemoryGroup, new PageContent[]{textFieldOption, comboOption, textFieldOption2}, 1);
    }

    public Description getDescription() {
        return null;
    }

    public void finalize(PagesResolver pagesResolver) {
    }

    public Expression getVisibility() {
        return null;
    }

    private int getDefaultValue(String string, int n) {
        try {
            return (int)Long.parseLong(this.memoriesProperties.getProperty(DEFAULT_VALUE_PREFIX + string));
        }
        catch (Exception exception) {
            return n;
        }
    }
}

