/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.microui.image.extension;

import com.is2t.microej.workbench.extension.Page;
import com.is2t.microej.workbench.extension.PagesResolver;
import com.is2t.microej.workbench.std.launch.ext.BrowseOption;
import com.is2t.microej.workbench.std.launch.ext.CheckBoxOption;
import com.is2t.microej.workbench.std.launch.ext.Description;
import com.is2t.microej.workbench.std.launch.ext.Group;
import com.is2t.microej.workbench.std.launch.ext.HiddenOption;
import com.is2t.microej.workbench.std.launch.ext.ILabel;
import com.is2t.microej.workbench.std.launch.ext.InputOption;
import com.is2t.microej.workbench.std.launch.ext.LabelGroup;
import com.is2t.microej.workbench.std.launch.ext.LabelOption;
import com.is2t.microej.workbench.std.launch.ext.OptionChangedListener;
import com.is2t.microej.workbench.std.launch.ext.OptionValidator;
import com.is2t.microej.workbench.std.launch.ext.PageContent;
import com.is2t.microej.workbench.std.launch.ext.StringLabel;
import com.is2t.microej.workbench.std.launch.ext.XHTMLDescription;
import com.is2t.microej.workbench.std.launch.ext.expr.BinaryExpression;
import com.is2t.microej.workbench.std.launch.ext.expr.CheckBoxSelected;
import com.is2t.microej.workbench.std.launch.ext.expr.Expression;
import com.is2t.microej.workbench.std.launch.ext.validator.FileOptionValidator;
import com.is2t.microui.image.extension.ImageFormat;
import com.is2t.microui.image.extension.MicroUIImageMessages;
import java.util.ArrayList;
import java.util.Properties;

public class ImagePage
implements Page,
ImageFormat {
    public static final String INIT_PROP = "initialize";
    public static final String CHECK_PROP = "check";
    public static final String OPEN_PROP = "open";
    public static final String DRAW_PROP = "draw";
    public static final String INIT_METHOD = "Initialize";
    public static final String CHECK_METHOD = "Check";
    public static final String OPEN_METHOD = "Open";
    public static final String DRAW_METHOD = "Draw";
    public static final String NOIMAGE_METHOD = "com_ist_display_image_Image___empty";
    public static final String PNGIMAGE_METHOD = "com_ist_display_image_Image___pngBasic";
    public static final String BMPMIMAGE_METHOD = "com_ist_display_image_Image___bmpmBasic";
    private static final String PROPERTIES_FILE = "imagegen.properties";
    private static final String PROPERTY_EXTERNAL_RESOURCES = "external.resources";
    private static final String PROPERTY_MicroUISupportImagesFile = "ej.microui.imageConverter.file";
    private static final String PROPERTY_MicroUISupportImagesFileExternal = "ej.microui.imageConverter.file.external";
    private static final String PROPERTY_MicroUISupportImageConvertImage = "ej.microui.imageConverter.useIt";
    private static final String PROPERTY_MicroUISupportImageDecoderHeader = "ej.microui.imageDecoder.";
    private static final String PROPERTY_MicroUISupportImageDecoderPNG = "png";
    private static final String PROPERTY_MicroUISupportImageDecoderBMPM = "bmpm";

    public PageContent getContent() {
        return this.buildMicroUIImageGroup();
    }

    public String getName() {
        return MicroUIImageMessages.CategoryImage;
    }

    public String getParent() {
        return "com.is2t.microui.extension.MicroUIPage";
    }

    public Expression getVisibility() {
        return null;
    }

    public Description getDescription() {
        return null;
    }

    public void finalize(PagesResolver pagesResolver) {
    }

    public Group buildMicroUIImageGroup() {
        ArrayList<InputOption> arrayList = new ArrayList<InputOption>();
        LabelOption labelOption = new LabelOption(MicroUIImageMessages.LabelPresentation);
        arrayList.add((InputOption)labelOption);
        CheckBoxOption checkBoxOption = new CheckBoxOption((ILabel)new StringLabel(MicroUIImageMessages.LabelCheckbox), PROPERTY_MicroUISupportImageConvertImage);
        checkBoxOption.setInitialValue(true);
        checkBoxOption.setDescription((Description)new XHTMLDescription(MicroUIImageMessages.DescriptionCheckbox));
        arrayList.add((InputOption)checkBoxOption);
        this.addListOption(arrayList, checkBoxOption, MicroUIImageMessages.LabelListInternal, PROPERTY_MicroUISupportImagesFile);
        this.addExternalResourcesOption(arrayList, checkBoxOption);
        PageContent[] pageContentArray = arrayList.toArray(new PageContent[0]);
        LabelGroup labelGroup = new LabelGroup(MicroUIImageMessages.LabelGroup, pageContentArray, 1);
        labelGroup.setDescription((Description)new XHTMLDescription(MicroUIImageMessages.DescriptionGroupImage));
        return labelGroup;
    }

    private void addExternalResourcesOption(ArrayList<InputOption> arrayList, CheckBoxOption checkBoxOption) {
        try {
            Properties properties = new Properties();
            properties.load(ImagePage.class.getClassLoader().getResourceAsStream(PROPERTIES_FILE));
            if (properties.getProperty(PROPERTY_EXTERNAL_RESOURCES).trim().toLowerCase().equals(Boolean.TRUE.toString())) {
                this.addListOption(arrayList, checkBoxOption, MicroUIImageMessages.LabelListExternal, PROPERTY_MicroUISupportImagesFileExternal);
            }
        }
        catch (Exception exception) {}
    }

    private void addListOption(ArrayList<InputOption> arrayList, CheckBoxOption checkBoxOption, String string, String string2) {
        LabelOption labelOption = new LabelOption(string);
        arrayList.add((InputOption)labelOption);
        CheckBoxOption checkBoxOption2 = new CheckBoxOption((ILabel)new StringLabel(MicroUIImageMessages.LabelCheckboxExplicitListFile), String.valueOf(string2) + ".enabled");
        checkBoxOption2.setInitialValue(false);
        checkBoxOption2.setDescription((Description)new XHTMLDescription(MicroUIImageMessages.DescriptionCheckboxExplicitListFile));
        checkBoxOption2.setEnableCondition((Expression)new CheckBoxSelected(checkBoxOption));
        arrayList.add((InputOption)checkBoxOption2);
        BrowseOption browseOption = new BrowseOption((ILabel)new StringLabel(""), string2, MicroUIImageMessages.LabelButtonBrowse, MicroUIImageMessages.LabelBrowse, new String[]{"*.list", "*.*"});
        browseOption.setInitialValue("");
        browseOption.setOptionValidator((OptionValidator)new FileOptionValidator(MicroUIImageMessages.LabelListInternal, true, false, true, false));
        browseOption.setDescription((Description)new XHTMLDescription(MicroUIImageMessages.DescriptionListFile));
        browseOption.setEnableCondition((Expression)new BinaryExpression(3, (Expression)new CheckBoxSelected(checkBoxOption), (Expression)new CheckBoxSelected(checkBoxOption2)));
        browseOption.emptyFileIsValid(true);
        browseOption.fileMustExist(true);
        arrayList.add((InputOption)browseOption);
    }

    public Group buildDynamicImagesSupportGroup(int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            return null;
        }
        ArrayList<Group> arrayList = new ArrayList<Group>();
        int n = -1;
        while (++n < nArray.length) {
            switch (nArray[n]) {
                case 9: {
                    arrayList.add(this.buildDynamicImageSupportGroup(MicroUIImageMessages.LabelDecoderBMPM, (Description)new XHTMLDescription(MicroUIImageMessages.DescriptionDecoderBMPM), PROPERTY_MicroUISupportImageDecoderBMPM, true, BMPMIMAGE_METHOD));
                    break;
                }
                case 100: {
                    arrayList.add(this.buildDynamicImageSupportGroup(MicroUIImageMessages.LabelDecoderPNG, (Description)new XHTMLDescription(MicroUIImageMessages.DescriptionDecoderPNG), PROPERTY_MicroUISupportImageDecoderPNG, true, PNGIMAGE_METHOD));
                    break;
                }
            }
        }
        if (arrayList.size() > 0) {
            LabelGroup labelGroup = new LabelGroup(MicroUIImageMessages.LabelImageDecoders, (PageContent[])arrayList.toArray(new Group[0]), 1);
            labelGroup.setDescription((Description)new XHTMLDescription(MicroUIImageMessages.DescriptionImageDecoders));
            return labelGroup;
        }
        return null;
    }

    private Group buildDynamicImageSupportGroup(String string, Description description, String string2, boolean bl, final String string3) {
        final CheckBoxOption checkBoxOption = new CheckBoxOption((ILabel)new StringLabel(string), PROPERTY_MicroUISupportImageDecoderHeader + string2);
        final HiddenOption hiddenOption = new HiddenOption("", PROPERTY_MicroUISupportImageDecoderHeader + string2 + "." + INIT_PROP, String.valueOf(bl ? string3 : NOIMAGE_METHOD) + INIT_METHOD);
        final HiddenOption hiddenOption2 = new HiddenOption("", PROPERTY_MicroUISupportImageDecoderHeader + string2 + "." + CHECK_PROP, String.valueOf(bl ? string3 : NOIMAGE_METHOD) + CHECK_METHOD);
        final HiddenOption hiddenOption3 = new HiddenOption("", PROPERTY_MicroUISupportImageDecoderHeader + string2 + "." + OPEN_PROP, String.valueOf(bl ? string3 : NOIMAGE_METHOD) + OPEN_METHOD);
        final HiddenOption hiddenOption4 = new HiddenOption("", PROPERTY_MicroUISupportImageDecoderHeader + string2 + "." + DRAW_PROP, String.valueOf(bl ? string3 : NOIMAGE_METHOD) + DRAW_METHOD);
        OptionChangedListener optionChangedListener = new OptionChangedListener(){

            public void changed() {
                boolean bl = checkBoxOption.getSelection();
                hiddenOption.setOutputValue(String.valueOf(bl ? string3 : ImagePage.NOIMAGE_METHOD) + ImagePage.INIT_METHOD);
                hiddenOption2.setOutputValue(String.valueOf(bl ? string3 : ImagePage.NOIMAGE_METHOD) + ImagePage.CHECK_METHOD);
                hiddenOption3.setOutputValue(String.valueOf(bl ? string3 : ImagePage.NOIMAGE_METHOD) + ImagePage.OPEN_METHOD);
                hiddenOption4.setOutputValue(String.valueOf(bl ? string3 : ImagePage.NOIMAGE_METHOD) + ImagePage.DRAW_METHOD);
            }
        };
        checkBoxOption.setInitialValue(bl);
        checkBoxOption.setDescription(description);
        checkBoxOption.addOptionChangedListener(optionChangedListener);
        return new Group(new PageContent[]{checkBoxOption, hiddenOption, hiddenOption2, hiddenOption3, hiddenOption4}, 1);
    }
}

