/*
 * Decompiled with CFR 0.152.
 */
package ej.library.iot.rcommand.bluetooth;

import ej.annotation.Nullable;
import ej.library.iot.rcommand.bluetooth.commands.AddServiceCommand;
import ej.library.iot.rcommand.bluetooth.commands.ConnectCommand;
import ej.library.iot.rcommand.bluetooth.commands.DisableCommand;
import ej.library.iot.rcommand.bluetooth.commands.DisconnectCommand;
import ej.library.iot.rcommand.bluetooth.commands.DiscoverServicesCommand;
import ej.library.iot.rcommand.bluetooth.commands.EnableCommand;
import ej.library.iot.rcommand.bluetooth.commands.PollEventCommand;
import ej.library.iot.rcommand.bluetooth.commands.SendExecuteWriteResponseCommand;
import ej.library.iot.rcommand.bluetooth.commands.SendNotificationCommand;
import ej.library.iot.rcommand.bluetooth.commands.SendPairRequestCommand;
import ej.library.iot.rcommand.bluetooth.commands.SendPairResponseCommand;
import ej.library.iot.rcommand.bluetooth.commands.SendPasskeyResponseCommand;
import ej.library.iot.rcommand.bluetooth.commands.SendPrepareWriteResponseCommand;
import ej.library.iot.rcommand.bluetooth.commands.SendReadRequestCommand;
import ej.library.iot.rcommand.bluetooth.commands.SendReadResponseCommand;
import ej.library.iot.rcommand.bluetooth.commands.SendWriteRequestCommand;
import ej.library.iot.rcommand.bluetooth.commands.SendWriteResponseCommand;
import ej.library.iot.rcommand.bluetooth.commands.StartAdvertisingCommand;
import ej.library.iot.rcommand.bluetooth.commands.StartScanningCommand;
import ej.library.iot.rcommand.bluetooth.commands.StopAdvertisingCommand;
import ej.library.iot.rcommand.bluetooth.commands.StopScanningCommand;
import ej.library.iot.rcommand.bluetooth.notifications.EventAvailableNotificationListener;
import ej.rcommand.synchronous.Command;
import ej.rcommand.synchronous.RemoteCommandClient;
import java.io.IOException;
import java.util.concurrent.TimeoutException;

public class BluetoothHost {
    private static final BluetoothHost INSTANCE = new BluetoothHost();
    private final Object eventMonitor = new Object();
    @Nullable
    private RemoteCommandClient rcommandClient = null;
    private long commandTimeout = 0L;
    private boolean enabled = false;
    private int numAvailableEvents = 0;

    private BluetoothHost() {
    }

    public static BluetoothHost getInstance() {
        return INSTANCE;
    }

    public void setup(RemoteCommandClient rcommandClient, long commandTimeout) {
        rcommandClient.registerNotificationListener(new EventAvailableNotificationListener());
        this.rcommandClient = rcommandClient;
        this.commandTimeout = commandTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEventAvailable() {
        Object object = this.eventMonitor;
        synchronized (object) {
            ++this.numAvailableEvents;
            this.eventMonitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int waitEvent(byte[] buffer, int bufferLength) {
        while (true) {
            Object object = this.eventMonitor;
            synchronized (object) {
                while (true) {
                    if (!this.enabled || this.numAvailableEvents != 0) {
                        if (this.enabled) break;
                        return 0;
                    }
                    try {
                        this.eventMonitor.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                        return 0;
                    }
                }
                this.numAvailableEvents = Math.max(this.numAvailableEvents - 1, 0);
            }
            byte[] event = this.sendCommand(new PollEventCommand(), this.commandTimeout);
            if (event == null || event.length == 0) continue;
            if (event.length <= bufferLength) {
                System.arraycopy(event, 0, buffer, 0, event.length);
                return event.length;
            }
            System.out.println("WARNING: Bluetooth event discarded due to buffer being too small");
        }
    }

    public boolean enable() {
        this.enabled = this.sendBooleanCommand(new EnableCommand());
        return this.enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disable() {
        this.sendCommand(new DisableCommand(), this.commandTimeout);
        Object object = this.eventMonitor;
        synchronized (object) {
            this.enabled = false;
            this.numAvailableEvents = 0;
            this.eventMonitor.notifyAll();
        }
    }

    public boolean startScanning(byte filterAction, byte filterType, byte[] filterData, int filterDataSize) {
        return this.sendBooleanCommand(new StartScanningCommand(filterAction, filterType, filterData, filterDataSize));
    }

    public boolean stopScanning() {
        return this.sendBooleanCommand(new StopScanningCommand());
    }

    public boolean startAdvertising(byte[] advertisementData, int advertisementDataSize) {
        return this.sendBooleanCommand(new StartAdvertisingCommand(advertisementData, advertisementDataSize));
    }

    public boolean stopAdvertising() {
        return this.sendBooleanCommand(new StopAdvertisingCommand());
    }

    public boolean connect(byte[] deviceAddress) {
        return this.sendBooleanCommand(new ConnectCommand(deviceAddress));
    }

    public boolean disconnect(short connHandle) {
        return this.sendBooleanCommand(new DisconnectCommand(connHandle));
    }

    public boolean sendPairRequest(short connHandle) {
        return this.sendBooleanCommand(new SendPairRequestCommand(connHandle));
    }

    public boolean sendPairResponse(short connHandle, boolean accept) {
        return this.sendBooleanCommand(new SendPairResponseCommand(connHandle, accept));
    }

    public boolean sendPasskeyResponse(short connHandle, boolean accept, int passkey) {
        return this.sendBooleanCommand(new SendPasskeyResponseCommand(connHandle, accept, passkey));
    }

    public boolean discoverServices(short connHandle, @Nullable byte[] uuid) {
        return this.sendBooleanCommand(new DiscoverServicesCommand(connHandle, uuid));
    }

    public boolean addService(byte[] service, short[] handles) {
        int numAttr = service[16] + service[17];
        int serviceSize = 18 + numAttr * 20;
        return this.sendBooleanCommand(new AddServiceCommand(service, serviceSize, handles));
    }

    public boolean sendReadRequest(short connHandle, short attributeHandle) {
        return this.sendBooleanCommand(new SendReadRequestCommand(connHandle, attributeHandle));
    }

    public boolean sendWriteRequest(short connHandle, short attributeHandle, byte[] value, int valueSize, boolean noResponse) {
        return this.sendBooleanCommand(new SendWriteRequestCommand(connHandle, attributeHandle, value, valueSize, noResponse));
    }

    public boolean sendReadResponse(short connHandle, short attributeHandle, byte status, byte[] value, int valueSize) {
        return this.sendBooleanCommand(new SendReadResponseCommand(connHandle, attributeHandle, status, value, valueSize));
    }

    public boolean sendWriteResponse(short connHandle, short attributeHandle, byte status) {
        return this.sendBooleanCommand(new SendWriteResponseCommand(connHandle, attributeHandle, status));
    }

    public boolean sendPrepareWriteResponse(short connHandle, short attributeHandle, byte status, byte[] value, int valueSize, int offset) {
        return this.sendBooleanCommand(new SendPrepareWriteResponseCommand(connHandle, attributeHandle, status, value, valueSize, offset));
    }

    public boolean sendExecuteWriteResponse(short connHandle, short attributeHandle, byte status) {
        return this.sendBooleanCommand(new SendExecuteWriteResponseCommand(connHandle, attributeHandle, status));
    }

    public boolean sendNotification(short connHandle, short attributeHandle, byte[] value, int valueSize, boolean confirm) {
        return this.sendBooleanCommand(new SendNotificationCommand(connHandle, attributeHandle, value, valueSize, confirm));
    }

    @Nullable
    private <T> T sendCommand(Command<T> command, long timeout) {
        RemoteCommandClient rcommandClient = this.rcommandClient;
        if (rcommandClient == null) {
            return null;
        }
        try {
            return rcommandClient.execute(command, timeout);
        }
        catch (IOException | InterruptedException | TimeoutException exception) {
            System.out.println("WARNING: Bluetooth operation failed due to disconnection with Bluetooth Controller");
            return null;
        }
    }

    private boolean sendBooleanCommand(Command<Boolean> command) {
        Boolean result = this.sendCommand(command, this.commandTimeout);
        return result != null && result != false;
    }
}

