/*
 * Decompiled with CFR 0.152.
 */
package ej.bluetooth;

import com.is2t.hil.HIL;
import ej.bluetooth.NativesImplementation;
import java.util.ArrayDeque;
import java.util.Queue;

public class StubNativesImplementation
implements NativesImplementation {
    private static final byte GAP_SCAN_COMPLETED = 2;
    private static final byte GAP_ADVERTISEMENT_COMPLETED = 3;
    private static final StubNativesImplementation INSTANCE = new StubNativesImplementation();
    private final Object eventMonitor = new Object();
    private final Queue<byte[]> eventQueue = new ArrayDeque<byte[]>();
    private volatile boolean enabled = false;
    private short nextAttributeHandle = 0;

    private StubNativesImplementation() {
    }

    public static StubNativesImplementation getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int waitEvent(byte[] buffer, int bufferLength) {
        Object object = this.eventMonitor;
        synchronized (object) {
            while (this.enabled) {
                byte[] event = this.eventQueue.poll();
                if (event != null) {
                    int eventSize = event.length;
                    System.arraycopy(event, 0, buffer, 0, eventSize);
                    HIL.getInstance().flushContent((Object)buffer, 0, eventSize);
                    return eventSize;
                }
                try {
                    this.eventMonitor.wait();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean pushEvent(byte[] event) {
        Object object = this.eventMonitor;
        synchronized (object) {
            if (this.enabled) {
                this.eventQueue.add(event);
                this.eventMonitor.notifyAll();
            }
            return this.enabled;
        }
    }

    @Override
    public boolean enable() {
        this.enabled = true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disable() {
        Object object = this.eventMonitor;
        synchronized (object) {
            this.enabled = false;
            this.eventQueue.clear();
            this.eventMonitor.notifyAll();
        }
    }

    @Override
    public boolean addService(byte[] service, short[] handles) {
        if (!this.enabled) {
            return false;
        }
        int i = 0;
        while (i < handles.length) {
            this.nextAttributeHandle = (short)(this.nextAttributeHandle + 1);
            ++i;
        }
        HIL.getInstance().flushContent((Object)handles);
        return true;
    }

    @Override
    public boolean startScanning(byte filterAction, byte filterType, byte[] filterData, int filterDataSize) {
        return this.enabled;
    }

    @Override
    public boolean stopScanning() {
        return this.pushEvent(new byte[]{2});
    }

    @Override
    public boolean startAdvertising(byte[] advertisementData, int advertisementDataSize) {
        return this.enabled;
    }

    @Override
    public boolean stopAdvertising() {
        return this.pushEvent(new byte[]{3});
    }

    @Override
    public boolean connect(byte[] deviceAddress) {
        return false;
    }

    @Override
    public boolean disconnect(short connHandle) {
        throw new IllegalStateException();
    }

    @Override
    public boolean sendPairRequest(short connHandle) {
        throw new IllegalStateException();
    }

    @Override
    public boolean sendPairResponse(short connHandle, boolean accept) {
        throw new IllegalStateException();
    }

    @Override
    public boolean sendPasskeyResponse(short connHandle, boolean accept, int passkey) {
        throw new IllegalStateException();
    }

    @Override
    public boolean discoverServices(short connHandle, byte[] uuid) {
        throw new IllegalStateException();
    }

    @Override
    public boolean sendReadRequest(short connHandle, short attributeHandle) {
        throw new IllegalStateException();
    }

    @Override
    public boolean sendWriteRequest(short connHandle, short attributeHandle, byte[] value, int valueSize, boolean noResponse) {
        throw new IllegalStateException();
    }

    @Override
    public boolean sendReadResponse(short connHandle, short attributeHandle, byte status, byte[] value, int valueSize) {
        throw new IllegalStateException();
    }

    @Override
    public boolean sendWriteResponse(short connHandle, short attributeHandle, byte status) {
        throw new IllegalStateException();
    }

    @Override
    public boolean sendPrepareWriteResponse(short connHandle, short attributeHandle, byte status, byte[] value, int valueSize, int offset) {
        throw new IllegalStateException();
    }

    @Override
    public boolean sendExecuteWriteResponse(short connHandle, short attributeHandle, byte status) {
        throw new IllegalStateException();
    }

    @Override
    public boolean sendNotification(short connHandle, short attributeHandle, byte[] value, int valueSize, boolean confirm) {
        throw new IllegalStateException();
    }
}

