/*
 * Decompiled with CFR 0.152.
 */
package ej.bluetooth;

import com.is2t.hil.HIL;
import com.is2t.hil.StopListener;
import ej.bluetooth.NativesImplementation;
import ej.library.iot.rcommand.bluetooth.BluetoothHost;
import ej.library.iot.rcommand.bluetooth.commands.DisableCommand;
import ej.rcommand.impl.StreamRemoteConnection;
import ej.rcommand.synchronous.RemoteCommandClient;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NetNativesImplementation
implements NativesImplementation {
    private static final String PROPERTY_HOST = "s3.bluetooth.net.host";
    private static final String PROPERTY_PORT = "s3.bluetooth.net.port";
    private static final String PROPERTY_TIMEOUT = "s3.bluetooth.net.timeout";
    private static final String DEFAULT_HOST = "192.168.x.y";
    private static final int DEFAULT_PORT = 80;
    private static final int DEFAULT_TIMEOUT = 5000;
    private static final int SOCKET_BUFFER_SIZE = 1024;
    private static final NetNativesImplementation INSTANCE = new NetNativesImplementation();
    private final BluetoothHost host = BluetoothHost.getInstance();
    private boolean initialized = false;

    private NetNativesImplementation() {
    }

    public static NetNativesImplementation getInstance() {
        return INSTANCE;
    }

    public void initialize() throws IOException {
        if (this.initialized) {
            throw new IllegalStateException("Already initialized");
        }
        this.initialized = true;
        String host = System.getProperty(PROPERTY_HOST, DEFAULT_HOST);
        int port = Integer.getInteger(PROPERTY_PORT, 80);
        int timeout = Integer.getInteger(PROPERTY_TIMEOUT, 5000);
        Socket socket = new Socket();
        NetNativesImplementation.closeSocketOnSimulationStop(socket);
        socket.setReceiveBufferSize(1024);
        socket.setSendBufferSize(1024);
        socket.connect(new InetSocketAddress(host, port), timeout);
        Logger connectionLogger = Logger.getLogger(StreamRemoteConnection.class.getName());
        connectionLogger.setLevel(Level.OFF);
        StreamRemoteConnection conn = new StreamRemoteConnection(socket.getInputStream(), socket.getOutputStream());
        RemoteCommandClient rcommandClient = new RemoteCommandClient(conn);
        NetNativesImplementation.closeRcommandClientOnSimulationStop(rcommandClient);
        try {
            rcommandClient.execute(new DisableCommand(), timeout);
        }
        catch (TimeoutException e) {
            throw new IOException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        this.host.setup(rcommandClient, timeout);
    }

    @Override
    public int waitEvent(byte[] buffer, int bufferLength) {
        return this.host.waitEvent(buffer, bufferLength);
    }

    @Override
    public boolean enable() {
        return this.host.enable();
    }

    @Override
    public void disable() {
        this.host.disable();
    }

    @Override
    public boolean addService(byte[] service, short[] handles) {
        return this.host.addService(service, handles);
    }

    @Override
    public boolean startScanning(byte filterAction, byte filterType, byte[] filterData, int filterDataSize) {
        return this.host.startScanning(filterAction, filterType, filterData, filterDataSize);
    }

    @Override
    public boolean stopScanning() {
        return this.host.stopScanning();
    }

    @Override
    public boolean startAdvertising(byte[] advertisementData, int advertisementDataSize) {
        return this.host.startAdvertising(advertisementData, advertisementDataSize);
    }

    @Override
    public boolean stopAdvertising() {
        return this.host.stopAdvertising();
    }

    @Override
    public boolean connect(byte[] deviceAddress) {
        return this.host.connect(deviceAddress);
    }

    @Override
    public boolean disconnect(short connHandle) {
        return this.host.disconnect(connHandle);
    }

    @Override
    public boolean sendPairRequest(short connHandle) {
        return this.host.sendPairRequest(connHandle);
    }

    @Override
    public boolean sendPairResponse(short connHandle, boolean accept) {
        return this.host.sendPairResponse(connHandle, accept);
    }

    @Override
    public boolean sendPasskeyResponse(short connHandle, boolean accept, int passkey) {
        return this.host.sendPasskeyResponse(connHandle, accept, passkey);
    }

    @Override
    public boolean discoverServices(short connHandle, byte[] uuid) {
        return this.host.discoverServices(connHandle, uuid);
    }

    @Override
    public boolean sendReadRequest(short connHandle, short attributeHandle) {
        return this.host.sendReadRequest(connHandle, attributeHandle);
    }

    @Override
    public boolean sendWriteRequest(short connHandle, short attributeHandle, byte[] value, int valueSize, boolean noResponse) {
        return this.host.sendWriteRequest(connHandle, attributeHandle, value, valueSize, noResponse);
    }

    @Override
    public boolean sendReadResponse(short connHandle, short attributeHandle, byte status, byte[] value, int valueSize) {
        return this.host.sendReadResponse(connHandle, attributeHandle, status, value, valueSize);
    }

    @Override
    public boolean sendWriteResponse(short connHandle, short attributeHandle, byte status) {
        return this.host.sendWriteResponse(connHandle, attributeHandle, status);
    }

    @Override
    public boolean sendPrepareWriteResponse(short connHandle, short attributeHandle, byte status, byte[] value, int valueSize, int offset) {
        return this.host.sendPrepareWriteResponse(connHandle, attributeHandle, status, value, valueSize, offset);
    }

    @Override
    public boolean sendExecuteWriteResponse(short connHandle, short attributeHandle, byte status) {
        return this.host.sendExecuteWriteResponse(connHandle, attributeHandle, status);
    }

    @Override
    public boolean sendNotification(short connHandle, short attributeHandle, byte[] value, int valueSize, boolean confirm) {
        return this.host.sendNotification(connHandle, attributeHandle, value, valueSize, confirm);
    }

    private static void closeRcommandClientOnSimulationStop(final RemoteCommandClient rcommandClient) {
        HIL.getInstance().addStopListener(new StopListener(){

            public void stop(boolean isEvalVersion) {
                rcommandClient.stop();
            }
        });
    }

    private static void closeSocketOnSimulationStop(final Socket socket) {
        HIL.getInstance().addStopListener(new StopListener(){

            public void stop(boolean isEvalVersion) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        });
    }
}

