/*
 * Decompiled with CFR 0.152.
 */
package ej.bluetooth;

import com.is2t.hil.HIL;
import com.is2t.hil.NativeInterface;
import ej.bluetooth.NativesImplementation;
import ej.bluetooth.NetNativesImplementation;
import ej.bluetooth.StubNativesImplementation;
import java.io.IOException;

public class BluetoothNatives {
    private static final String MODE_PROPERTY = "s3.bluetooth.mode";
    private static final String NET_MODE = "net";
    private static final NativeInterface HIL = com.is2t.hil.HIL.getInstance();
    private static final NativesImplementation IMPLEMENTATION = BluetoothNatives.getImplementation();

    private BluetoothNatives() {
    }

    private static NativesImplementation getImplementation() {
        String mode = System.getProperty(MODE_PROPERTY);
        if (mode != null && mode.equals(NET_MODE)) {
            try {
                NetNativesImplementation net = NetNativesImplementation.getInstance();
                net.initialize();
                return net;
            }
            catch (IOException iOException) {
                System.out.println("WARNING: Failed to initialize Bluetooth Controller. Using stub mode instead.");
            }
        }
        return StubNativesImplementation.getInstance();
    }

    public static int waitEvent(byte[] buffer, int bufferLength) {
        int eventLength = IMPLEMENTATION.waitEvent(buffer, bufferLength);
        HIL.flushContent((Object)buffer, 0, eventLength);
        return eventLength;
    }

    public static boolean enable() {
        return IMPLEMENTATION.enable();
    }

    public static void disable() {
        IMPLEMENTATION.disable();
    }

    public static boolean addService(byte[] service, short[] handles) {
        HIL.refreshContent((Object)service);
        if (IMPLEMENTATION.addService(service, handles)) {
            HIL.flushContent((Object)handles);
            return true;
        }
        return false;
    }

    public static boolean startScanning(byte filterAction, byte filterType, byte[] filterData, int filterDataSize) {
        HIL.refreshContent((Object)filterData, 0, filterDataSize);
        return IMPLEMENTATION.startScanning(filterAction, filterType, filterData, filterDataSize);
    }

    public static boolean stopScanning() {
        return IMPLEMENTATION.stopScanning();
    }

    public static boolean startAdvertising(byte[] advertisementData, int advertisementDataSize) {
        HIL.refreshContent((Object)advertisementData, 0, advertisementDataSize);
        return IMPLEMENTATION.startAdvertising(advertisementData, advertisementDataSize);
    }

    public static boolean stopAdvertising() {
        return IMPLEMENTATION.stopAdvertising();
    }

    public static boolean connect(byte[] deviceAddress) {
        HIL.refreshContent((Object)deviceAddress, 0, 7);
        return IMPLEMENTATION.connect(deviceAddress);
    }

    public static boolean disconnect(short connHandle) {
        return IMPLEMENTATION.disconnect(connHandle);
    }

    public static boolean sendPairRequest(short connHandle) {
        return IMPLEMENTATION.sendPairRequest(connHandle);
    }

    public static boolean sendPairResponse(short connHandle, boolean accept) {
        return IMPLEMENTATION.sendPairResponse(connHandle, accept);
    }

    public static boolean sendPasskeyResponse(short connHandle, boolean accept, int passkey) {
        return IMPLEMENTATION.sendPasskeyResponse(connHandle, accept, passkey);
    }

    public static boolean discoverServices(short connHandle, byte[] uuid) {
        if (uuid != null) {
            HIL.refreshContent((Object)uuid);
        }
        return IMPLEMENTATION.discoverServices(connHandle, uuid);
    }

    public static boolean sendReadRequest(short connHandle, short attributeHandle) {
        return IMPLEMENTATION.sendReadRequest(connHandle, attributeHandle);
    }

    public static boolean sendWriteRequest(short connHandle, short attributeHandle, byte[] value, int valueSize, boolean noResponse) {
        HIL.refreshContent((Object)value, 0, valueSize);
        return IMPLEMENTATION.sendWriteRequest(connHandle, attributeHandle, value, valueSize, noResponse);
    }

    public static boolean sendReadResponse(short connHandle, short attributeHandle, byte status, byte[] value, int valueSize) {
        HIL.refreshContent((Object)value, 0, valueSize);
        return IMPLEMENTATION.sendReadResponse(connHandle, attributeHandle, status, value, valueSize);
    }

    public static boolean sendWriteResponse(short connHandle, short attributeHandle, byte status) {
        return IMPLEMENTATION.sendWriteResponse(connHandle, attributeHandle, status);
    }

    public static boolean sendPrepareWriteResponse(short connHandle, short attributeHandle, byte status, byte[] value, int valueSize, int offset) {
        return IMPLEMENTATION.sendPrepareWriteResponse(connHandle, attributeHandle, status, value, valueSize, offset);
    }

    public static boolean sendExecuteWriteResponse(short connHandle, short attributeHandle, byte status) {
        return IMPLEMENTATION.sendExecuteWriteResponse(connHandle, attributeHandle, status);
    }

    public static boolean sendNotification(short connHandle, short attributeHandle, byte[] value, int valueSize, boolean confirm) {
        HIL.refreshContent((Object)value, 0, valueSize);
        return IMPLEMENTATION.sendNotification(connHandle, attributeHandle, value, valueSize, confirm);
    }
}

