/*
 * Decompiled with CFR 0.152.
 */
package jdwp;

import com.ist.debug.support.Reply;
import com.militsa.tools.BitManipulation;
import jdwp.Tag;

public class Value
implements Tag {
    public byte tag;
    public long data;

    public Value() {
    }

    public Value(byte tag, long data) {
        this.init(tag, data);
    }

    public void init(byte tag, long data) {
        this.tag = tag;
        this.data = data;
    }

    public static int sizeof(int tag) {
        switch (tag) {
            case 86: {
                return 0;
            }
            case 66: 
            case 90: {
                return 1;
            }
            case 67: 
            case 83: {
                return 2;
            }
            case 70: 
            case 73: 
            case 76: 
            case 91: 
            case 99: 
            case 103: 
            case 108: 
            case 115: 
            case 116: {
                return 4;
            }
            case 68: 
            case 74: {
                return 8;
            }
        }
        System.err.println("INVALID TAG (" + tag + ") in Value.sizeof()");
        return 0;
    }

    public int put(byte[] buf, int offset, boolean useTag) {
        if (useTag) {
            buf[offset++] = this.tag;
        }
        switch (this.tag) {
            case 86: {
                return offset;
            }
            case 66: 
            case 90: {
                buf[offset] = (byte)(this.data & 0xFFL);
                return offset + 1;
            }
            case 67: 
            case 83: {
                BitManipulation.putShort(buf, offset, true, (short)(this.data & 0xFFFFL));
                return offset + 2;
            }
            case 70: 
            case 73: 
            case 76: 
            case 91: 
            case 99: 
            case 103: 
            case 108: 
            case 115: 
            case 116: {
                BitManipulation.putInt(buf, offset, true, (int)this.data);
                return offset + 4;
            }
            case 68: 
            case 74: {
                BitManipulation.putLong(buf, offset, true, this.data);
                return offset + 8;
            }
        }
        System.err.println("INVALID TAG (" + this.tag + ") in Value.put()");
        return 0;
    }

    public void put(Reply reply, boolean useTag) {
        if (useTag) {
            reply.putByte(this.tag);
        }
        switch (this.tag) {
            case 86: {
                break;
            }
            case 66: 
            case 90: {
                reply.putByte((byte)(this.data & 0xFFL));
                break;
            }
            case 67: 
            case 83: {
                reply.putShort((short)(this.data & 0xFFFFL));
                break;
            }
            case 70: 
            case 73: 
            case 76: 
            case 91: 
            case 99: 
            case 103: 
            case 108: 
            case 115: 
            case 116: {
                reply.putInt((int)this.data);
                break;
            }
            case 68: 
            case 74: {
                reply.putLong(this.data);
                break;
            }
            default: {
                System.err.println("INVALID TAG (" + this.tag + ") in Value.put()");
            }
        }
    }

    public static int get(Value value, byte[] buf, int offset) {
        byte tag = buf[offset++];
        switch (tag) {
            case 86: {
                value.init(tag, 0L);
                return offset;
            }
            case 66: 
            case 90: {
                value.init(tag, buf[offset++]);
                return offset;
            }
            case 67: 
            case 83: {
                value.init(tag, BitManipulation.getShort(buf, offset, true));
                return offset + 2;
            }
            case 70: 
            case 73: 
            case 76: 
            case 91: 
            case 99: 
            case 103: 
            case 108: 
            case 115: 
            case 116: {
                value.init(tag, BitManipulation.getInt(buf, offset, true));
                return offset + 4;
            }
            case 68: 
            case 74: {
                value.init(tag, BitManipulation.getLong(buf, offset, true));
                return offset + 8;
            }
        }
        System.err.println("INVALID TAG (" + tag + ") in Value.get()");
        return 0;
    }

    public int size() {
        return Value.sizeof(this.tag) + 1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[" + this.tag + ",");
        int high = (int)(this.data >>> 32);
        int low = (int)(this.data & 0xFFFFFFFFFFFFFFFFL);
        int i = 4;
        while (--i >= 0) {
            sb.append(high >>> i * 8 & 0xFF).append(',');
        }
        i = 4;
        while (--i > 0) {
            sb.append(low >>> i * 8 & 0xFF).append(',');
        }
        sb.append(low & 0xFF).append(']');
        return sb.toString();
    }
}

