/*
 * Decompiled with CFR 0.152.
 */
package jdwp;

import com.militsa.tools.BitManipulation;
import jdwp.Error;

public class Utilities
implements Error {
    private Utilities() {
    }

    public static String errorName(int errorCode) {
        switch (errorCode) {
            case 0: {
                return "NONE";
            }
            case 10: {
                return "INVALID_THREAD";
            }
            case 11: {
                return "INVALID_THREAD_GROUP";
            }
            case 12: {
                return "INVALID_PRIORITY";
            }
            case 13: {
                return "THREAD_NOT_SUSPENDED";
            }
            case 14: {
                return "THREAD_SUSPENDED";
            }
            case 20: {
                return "INVALID_OBJECT";
            }
            case 21: {
                return "INVALID_CLASS";
            }
            case 22: {
                return "CLASS_NOT_PREPARED";
            }
            case 23: {
                return "INVALID_METHOD_ID";
            }
            case 24: {
                return "INVALID_LOCATION";
            }
            case 25: {
                return "INVALID_FIELDID";
            }
            case 30: {
                return "INVALID_FRAMEID";
            }
            case 31: {
                return "NO_MORE_FRAMES";
            }
            case 32: {
                return "OPAQUE_FRAME";
            }
            case 33: {
                return "NOT_CURRENT_FRAMES";
            }
            case 34: {
                return "TYPE_MISMATCH";
            }
            case 35: {
                return "INVALID_SLOT";
            }
            case 40: {
                return "DUPLICATE";
            }
            case 41: {
                return "NOT_FOUND";
            }
            case 50: {
                return "INVALID_MONITOR";
            }
            case 51: {
                return "NOT_MONITOR_OWNER";
            }
            case 52: {
                return "INTERRUPT";
            }
            case 60: {
                return "INVALID_CLASS_FORMAT";
            }
            case 61: {
                return "CIRCULAR_CLASS_DEFINITION";
            }
            case 62: {
                return "FAILS_VERIFICATION";
            }
            case 63: {
                return "ADD_METHOR_NOT_IMPLEMENTED";
            }
            case 64: {
                return "SCHEMA_CHANGE_NOT_IMPLEMENTED";
            }
            case 65: {
                return "INVALID_TYPESTATE";
            }
            case 66: {
                return "HIERARCHY_CHANGE_NOT_IMPLEMENTED";
            }
            case 67: {
                return "DELETE_METHOD_NOT_IMPLEMENTED";
            }
            case 68: {
                return "UNSUPPORTED_VERSION";
            }
            case 69: {
                return "NAMES_DONT_MATCH";
            }
            case 70: {
                return "CLASS_MODIFIERS_CHANGE_NOT_IMPLEMENTED";
            }
            case 71: {
                return "METHOD_MOFIDIERS_CHANGE_NOT_IMPLEMENTED";
            }
            case 99: {
                return "NOT_IMPLEMENTED";
            }
            case 100: {
                return "NULL_POINTER";
            }
            case 101: {
                return "ABSENT_INFORMATION";
            }
            case 102: {
                return "INVALID_EVENT_TYPE";
            }
            case 110: {
                return "OUT_OF_MEMORY";
            }
            case 111: {
                return "ACCESS_DENIED";
            }
            case 112: {
                return "VM_DEAD";
            }
            case 113: {
                return "INTERNAL";
            }
            case 115: {
                return "UNATTACHED_THREAD";
            }
            case 500: {
                return "INVALID_TAG";
            }
            case 502: {
                return "ALREADY_INVOKING";
            }
            case 503: {
                return "INVALID_INDEX";
            }
            case 504: {
                return "INVALID_LENGTH";
            }
            case 506: {
                return "INVALID_STRING";
            }
            case 507: {
                return "INVALID_CLASS_LOADER";
            }
            case 508: {
                return "INVALID_ARRAY";
            }
            case 509: {
                return "TRANSPORT_LOAD";
            }
            case 510: {
                return "TRANSPORT_INIT";
            }
            case 511: {
                return "NATIVE_METHOD";
            }
            case 512: {
                return "INVALID_COUNT";
            }
        }
        return "UNKNOWN_ERROR_ID(!!!)";
    }

    public static String tagName(int tag) {
        switch (tag) {
            case 66: {
                return "BYTE";
            }
            case 90: {
                return "BOOLEAN";
            }
            case 67: {
                return "CHAR";
            }
            case 83: {
                return "SHORT";
            }
            case 91: {
                return "ARRAY";
            }
            case 76: {
                return "OBJECT";
            }
            case 115: {
                return "STRING";
            }
            case 116: {
                return "THREAD";
            }
            case 103: {
                return "THREAD_GROUP";
            }
            case 108: {
                return "CLASS_LOADER";
            }
            case 99: {
                return "CLASS_OBJECT";
            }
            case 70: {
                return "FLOAT";
            }
            case 73: {
                return "INT";
            }
            case 68: {
                return "DOUBLE";
            }
            case 74: {
                return "LONG";
            }
        }
        return "UNKNOWN_TAG";
    }

    public static String toStringPacket(byte[] header, byte[] data) {
        int length = BitManipulation.getInt(header, 0, true);
        StringBuffer sb = new StringBuffer("  [Header][");
        if (header.length >= 11) {
            int i = 0;
            while (i < 10) {
                sb.append(header[i]).append(',');
                ++i;
            }
            sb.append(header[10]).append("]\n  [  Data][");
            int expectedDataLength = length - 11;
            if (expectedDataLength > 0 && data.length >= expectedDataLength) {
                int i2 = 0;
                while (i2 < expectedDataLength - 1) {
                    sb.append(data[i2]).append(',');
                    ++i2;
                }
                sb.append(data[expectedDataLength - 1]).append("]");
            } else if (expectedDataLength == 0) {
                sb.append("NO DATA]");
            } else {
                int i3 = 0;
                while (i3 < data.length - 1) {
                    sb.append(data[i3]).append(',');
                    ++i3;
                }
                if (data.length > 0) {
                    sb.append(data[data.length - 1]);
                }
                sb.append(" ***WRONG DATA SIZE ?*** ]");
            }
        } else {
            int i = 0;
            while (i < header.length - 1) {
                sb.append(header[i]).append(',');
                ++i;
            }
            if (header.length > 0) {
                sb.append(header[header.length - 1]);
            }
            sb.append(" ***WRONG HEADER SIZE ?*** ]\n  [  Data][...unable to print data]");
        }
        return sb.toString();
    }
}

