/*
 * Decompiled with CFR 0.152.
 */
package jdwp;

import com.ist.debug.support.Reply;
import com.militsa.tools.BitManipulation;

public class Location {
    private static final String[] TYPE_TAG_STR = new String[]{"", "class", "interface", "array"};
    public byte typeTag;
    public int classID;
    public int realMethodClassID;
    public int methodID;
    public long index;

    public Location() {
    }

    public Location(byte typeTag, int classID, int realMethodClassID, int methodID, long index) {
        this.init(typeTag, classID, realMethodClassID, methodID, index);
    }

    public final Location init(byte typeTag, int classID, int realMethodClassID, int methodID, long index) {
        this.typeTag = typeTag;
        this.classID = classID;
        this.realMethodClassID = realMethodClassID;
        this.methodID = methodID;
        this.index = index;
        if (index < 0L) {
            new Exception().printStackTrace();
        }
        return this;
    }

    public Location(byte[] buf, int offset) {
        this.typeTag = buf[offset];
        this.classID = BitManipulation.getInt(buf, ++offset, true) - 1;
        this.realMethodClassID = BitManipulation.getInt(buf, offset += 4, true) - 1;
        this.methodID = BitManipulation.getInt(buf, offset + 4, true);
        this.index = BitManipulation.getLong(buf, offset += 8, true);
        if (this.index < 0L) {
            new Exception().printStackTrace();
        }
    }

    public String toString() {
        return "[(" + TYPE_TAG_STR[this.typeTag] + " " + this.classID + ")::" + this.realMethodClassID + ":" + this.methodID + ":" + this.index + "]";
    }

    public int put(byte[] buf, int offset) {
        buf[offset] = this.typeTag;
        BitManipulation.putInt(buf, ++offset, true, this.classID + 1);
        BitManipulation.putInt(buf, offset += 4, true, this.realMethodClassID + 1);
        BitManipulation.putInt(buf, offset + 4, true, this.methodID);
        BitManipulation.putLong(buf, offset += 8, true, this.index);
        return offset += 8;
    }

    public void put(Reply reply) {
        reply.putByte(this.typeTag);
        reply.putInt(this.classID + 1);
        reply.putInt(this.realMethodClassID + 1);
        reply.putInt(this.methodID);
        reply.putLong(this.index);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.typeTag;
        result = 31 * result + this.classID;
        result = 31 * result + this.realMethodClassID;
        result = 31 * result + this.methodID;
        result = 31 * result + (int)this.index;
        return result;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Location) {
            Location otherLocation = (Location)other;
            return this.typeTag == otherLocation.typeTag && this.classID == otherLocation.classID && this.realMethodClassID == otherLocation.realMethodClassID && this.methodID == otherLocation.methodID && this.index == otherLocation.index;
        }
        return false;
    }
}

