/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.io;

import com.is2t.cldc.support.ConnectorImpl;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connection;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.InputConnection;
import javax.microedition.io.OutputConnection;

public class Connector {
    public static final int READ = 1;
    public static final int WRITE = 2;
    public static final int READ_WRITE = 3;
    public static final String SUPPORT_PREFIX = "com.is2t.cldc.support.";
    private static final String ConnectorImplProperty = "com.is2t.cldc.support.connector.impl";
    private static ConnectorImpl impl;

    static {
        ConnectorImpl t;
        String implClassname = System.getProperty(ConnectorImplProperty);
        if (implClassname != null) {
            try {
                t = (ConnectorImpl)Class.forName(implClassname).newInstance();
            }
            catch (Throwable throwable) {}
        }
        t = null;
        impl = t;
    }

    private Connector() {
    }

    public static Connection open(String name) throws IOException {
        return Connector.open(name, 3, false);
    }

    public static Connection open(String name, int mode) throws IOException {
        return Connector.open(name, mode, false);
    }

    public static Connection open(String name, int mode, boolean timeouts) throws IOException {
        if (impl == null) {
            throw new ConnectionNotFoundException(name);
        }
        return impl.open(name, mode, timeouts);
    }

    public static DataInputStream openDataInputStream(String name) throws IOException {
        return new DataInputStream(Connector.openInputStream(name));
    }

    public static DataOutputStream openDataOutputStream(String name) throws IOException {
        return new DataOutputStream(Connector.openOutputStream(name));
    }

    public static InputStream openInputStream(String name) throws IOException {
        InputStream inputStream;
        Connection con = Connector.open(name, 1, false);
        try {
            inputStream = ((InputConnection)con).openInputStream();
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            con.close();
            throw throwable;
        }
        con.close();
        return inputStream;
    }

    public static OutputStream openOutputStream(String name) throws IOException {
        OutputStream outputStream;
        Connection con = Connector.open(name, 2, false);
        try {
            outputStream = ((OutputConnection)con).openOutputStream();
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            con.close();
            throw throwable;
        }
        con.close();
        return outputStream;
    }
}

