/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Collection;
import java.util.HashSetIterator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

public class HashSet
implements Set,
Cloneable {
    Hashtable hashTable;
    Object hValue = new Object();

    public HashSet() {
        this.hashTable = new Hashtable(16);
    }

    public HashSet(Collection c) {
        this();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            this.hashTable.put(it.next(), this.hValue);
        }
    }

    public HashSet(int initialCapacity) {
        this.hashTable = new Hashtable(initialCapacity);
    }

    public Iterator iterator() {
        return new HashSetIterator(this.hashTable.keys());
    }

    public int size() {
        return this.hashTable.size();
    }

    public boolean isEmpty() {
        return this.hashTable.isEmpty();
    }

    public boolean contains(Object o) {
        return this.hashTable.containsKey(o);
    }

    public boolean add(Object o) {
        if (this.hashTable.containsKey(o)) {
            return false;
        }
        this.hashTable.put(o, this.hValue);
        return true;
    }

    public boolean remove(Object o) {
        if (!this.hashTable.containsKey(o)) {
            return false;
        }
        this.hashTable.remove(o);
        return true;
    }

    public void clear() {
        this.hashTable.clear();
    }

    public Object clone() {
        return new HashSet(this);
    }

    public Object[] toArray() {
        Object[] ret = new Object[this.size()];
        int idx = -1;
        Iterator i = this.iterator();
        while (i.hasNext()) {
            ret[++idx] = i.next();
        }
        return ret;
    }

    public Object[] toArray(Object[] a) {
        Object[] ret = a.length >= this.size() ? a : new Object[this.size()];
        int idx = -1;
        Iterator i = this.iterator();
        while (i.hasNext()) {
            ret[++idx] = i.next();
        }
        return ret;
    }

    public boolean containsAll(Collection c) {
        Iterator it = c.iterator();
        while (it.hasNext()) {
            if (this.contains(it.next())) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(Collection c) {
        boolean changed = false;
        Iterator it = c.iterator();
        while (it.hasNext()) {
            Object elt = it.next();
            if (this.contains(elt)) continue;
            changed = true;
            this.add(elt);
        }
        return changed;
    }

    public boolean retainAll(Collection c) {
        boolean changed = false;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Object elt = it.next();
            if (c.contains(elt)) continue;
            this.remove(elt);
            changed = true;
        }
        return changed;
    }

    public boolean removeAll(Collection c) {
        boolean changed = false;
        Iterator it = c.iterator();
        while (it.hasNext()) {
            Object elt = it.next();
            if (this.contains(elt)) continue;
            this.remove(elt);
            changed = true;
        }
        return changed;
    }
}

