/*
 * Decompiled with CFR 0.152.
 */
package ej.ecom.connection.socket;

import ej.ecom.connection.AbstractOutputStream;
import ej.ecom.connection.network.NetworkDriver;
import ej.ecom.connection.socket.SocketConnectionImpl;
import java.io.IOException;

public class SocketOutputStreamImpl
extends AbstractOutputStream {
    protected SocketOutputStreamImpl(SocketConnectionImpl connection) throws IOException {
        super(connection);
    }

    public synchronized void write(int b) throws IOException {
        this.checkWrite();
        int errorCode = NetworkDriver.write(this.resourceId, b);
        if (errorCode < 0) {
            NetworkDriver.throwNewIOException(errorCode, 12);
        }
    }

    public synchronized void write(byte[] b, int off, int len) throws IOException {
        this.checkWrite(b, off, len);
        int resourceId = this.resourceId;
        int errorCode = NetworkDriver.writeBytes(resourceId, b, off, len);
        if (errorCode < 0) {
            NetworkDriver.throwNewIOException(errorCode, 12);
        }
    }

    public void flush() throws IOException {
        int res = NetworkDriver.flush(this.resourceId);
        if (res < 0) {
            NetworkDriver.throwNewIOException(res, 14);
        }
    }

    protected void closeNative() {
    }
}

