/*
 * Decompiled with CFR 0.152.
 */
package ej.ecom.connection.socket;

import ej.ecom.connection.AbstractInputStream;
import ej.ecom.connection.network.NetworkDriver;
import ej.ecom.connection.socket.SocketConnectionImpl;
import java.io.IOException;

public class SocketInputStreamImpl
extends AbstractInputStream {
    protected SocketInputStreamImpl(SocketConnectionImpl connection) {
        super(connection);
    }

    public synchronized int read() throws IOException {
        this.checkRead();
        int ret = NetworkDriver.read(this.resourceId);
        if (ret < -1) {
            NetworkDriver.throwNewIOException(ret, 14);
        }
        return ret;
    }

    public int available() throws IOException {
        this.checkRead();
        int available = NetworkDriver.available(this.resourceId);
        if (available < 0) {
            NetworkDriver.throwNewIOException(available, 14);
        }
        return available;
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        this.checkRead(b, off, len);
        if (len == 0) {
            return 0;
        }
        int res = NetworkDriver.readBytes(this.resourceId, b, off, len);
        if (res < -1) {
            NetworkDriver.throwNewIOException(res, 14);
        }
        return res;
    }

    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        this.checkRead();
        long res = NetworkDriver.skip(this.resourceId, n);
        if (res < 0L) {
            NetworkDriver.throwNewIOException((int)res, 14);
        }
        return res;
    }

    protected void closeNative() {
    }
}

