/*
 * Decompiled with CFR 0.152.
 */
package ej.ecom.connection.socket;

import ej.ecom.connection.AbstractConnectionImpl;
import ej.ecom.connection.network.NetworkDriver;
import ej.ecom.connection.socket.ServerSocketConnectionImpl;
import ej.ecom.connection.socket.SocketInputStreamImpl;
import ej.ecom.connection.socket.SocketOutputStreamImpl;
import ej.ecom.io.SocketConnection;
import ej.ecom.support.err.ConnectionErrorMessages;
import ej.error.ErrorMessages;
import ej.error.Message;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SocketConnectionImpl
extends AbstractConnectionImpl
implements SocketConnection {
    public static final int SCHEME_LENGTH = 9;
    public static final boolean TRACE = false;

    static SocketConnection open(String name, int mode, boolean timeouts) throws IOException {
        if (!name.startsWith("socket://")) {
            throw new IOException(Message.at((ErrorMessages)new ConnectionErrorMessages(), (int)3, (Object)name));
        }
        int separatorIndex = name.indexOf(58, 9);
        try {
            String host = name.substring(9, separatorIndex);
            boolean describedWithIP = NetworkDriver.isIPAddress(host);
            int port = Integer.parseInt(name.substring(++separatorIndex));
            int resId = NetworkDriver.openSocket(host, port, describedWithIP);
            return new SocketConnectionImpl(resId);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception exception) {
            throw new IOException(Message.at((ErrorMessages)new ConnectionErrorMessages(), (int)3, (Object)name));
        }
    }

    private SocketConnectionImpl(int resourceId) throws IOException {
        super(resourceId);
    }

    SocketConnectionImpl(ServerSocketConnectionImpl server, int resourceId) throws IOException {
        super(resourceId);
    }

    protected InputStream newInputStream() throws IOException {
        return new SocketInputStreamImpl(this);
    }

    protected OutputStream newOutputStream() throws IOException {
        return new SocketOutputStreamImpl(this);
    }

    protected void closeNative() {
        NetworkDriver.closeSocket(this.resourceId);
    }

    public String getAddress() throws IOException {
        if (this.closeState != 0) {
            throw new IOException(Message.at((ErrorMessages)new ConnectionErrorMessages(), (int)1));
        }
        int ip = NetworkDriver.getRemoteAddress(this.resourceId);
        return NetworkDriver.buildIpAddress(ip);
    }

    public String getLocalAddress() throws IOException {
        if (this.closeState != 0) {
            throw new IOException(Message.at((ErrorMessages)new ConnectionErrorMessages(), (int)1));
        }
        return NetworkDriver.getLocalAddressStr(this.resourceId, false);
    }

    public int getLocalPort() throws IOException {
        if (this.closeState != 0) {
            throw new IOException(Message.at((ErrorMessages)new ConnectionErrorMessages(), (int)1));
        }
        return NetworkDriver.getLocalPort(this.resourceId, false);
    }

    public int getPort() throws IOException {
        if (this.closeState != 0) {
            throw new IOException(Message.at((ErrorMessages)new ConnectionErrorMessages(), (int)1));
        }
        return NetworkDriver.getRemotePort(this.resourceId);
    }

    public int getSocketOption(byte option) throws IOException {
        return 0;
    }

    public void setSocketOption(byte option, int value) throws IOException {
    }
}

