/*
 * Decompiled with CFR 0.152.
 */
package ej.ecom.connection.socket;

import ej.ecom.connection.ConnectionErrorMessages;
import ej.ecom.connection.network.NetworkDriver;
import ej.ecom.connection.socket.SocketConnectionImpl;
import ej.ecom.io.ServerSocketConnection;
import ej.error.ErrorMessages;
import ej.error.Message;
import java.io.IOException;
import javax.microedition.io.StreamConnection;

public class ServerSocketConnectionImpl
implements ServerSocketConnection {
    public static final int SOCKET_SCHEME_LENGTH = 10;
    public static final int SERVERSOCKET_SCHEME_LENGTH = 15;
    private final int resourceId;
    private int port;
    private int address;
    private boolean closed;

    public static ServerSocketConnection open(String name, int mode, boolean timeouts) throws IOException {
        int port = 0;
        int address = 0;
        try {
            if (name.startsWith("serversocket://")) {
                int separatorIndex = name.indexOf(58, 15);
                String host = name.substring(15, separatorIndex);
                boolean describedWithIP = NetworkDriver.isIPAddress(host);
                if (!describedWithIP) {
                    throw new IOException(Message.at((ErrorMessages)new ej.ecom.support.err.ConnectionErrorMessages(), (int)3));
                }
                address = NetworkDriver.extractIpAddress(host);
                try {
                    port = Integer.parseInt(name.substring(++separatorIndex));
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (!name.equals("socket://:") && name.startsWith("socket://:")) {
                port = Integer.parseInt(name.substring(10));
            }
            return new ServerSocketConnectionImpl(address, port);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(Message.at((ErrorMessages)new ej.ecom.support.err.ConnectionErrorMessages(), (int)3));
        }
    }

    public ServerSocketConnectionImpl(int address, int port) throws IOException {
        int resourceId = this.resourceId = NetworkDriver.createServerSocket(address, port);
        if (resourceId < 0) {
            NetworkDriver.throwNewIOException(resourceId, 7);
        }
        this.port = port;
        this.address = address;
        this.closed = false;
    }

    public StreamConnection acceptAndOpen() throws IOException {
        if (this.closed) {
            throw new IOException(Message.at((ErrorMessages)new ej.ecom.support.err.ConnectionErrorMessages(), (int)1));
        }
        int clientId = NetworkDriver.accept(this.resourceId);
        if (clientId < 0) {
            throw new IOException(Message.at((ErrorMessages)new ej.ecom.support.err.ConnectionErrorMessages(), (int)1));
        }
        SocketConnectionImpl s = new SocketConnectionImpl(this, clientId);
        if (s == null) {
            throw new IOException(Message.at((ErrorMessages)new ConnectionErrorMessages(), (int)8));
        }
        return s;
    }

    public String getLocalAddress() throws IOException {
        if (this.closed) {
            throw new IOException(Message.at((ErrorMessages)new ej.ecom.support.err.ConnectionErrorMessages(), (int)1));
        }
        return NetworkDriver.getLocalAddressStr(this.resourceId, true);
    }

    public int getLocalPort() throws IOException {
        if (this.closed) {
            throw new IOException(Message.at((ErrorMessages)new ej.ecom.support.err.ConnectionErrorMessages(), (int)1));
        }
        return NetworkDriver.getLocalPort(this.resourceId, true);
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        NetworkDriver.closeServer(this.resourceId);
    }
}

