/*
 * Decompiled with CFR 0.152.
 */
package ej.ecom.connection.network;

import ej.ecom.connection.ConnectionErrorMessages;
import ej.ecom.connection.network.NetworkConfiguration;
import ej.error.ErrorMessages;
import ej.error.Message;
import java.io.IOException;

public class NetworkDriver {
    public static final boolean TRACE = false;
    protected static final long INVALID_MAC_ADDR = -1L;
    public static final int LOCALHOST_ADDR = 2130706433;
    public static final int ANY_ADDR = 0;
    public static final int ANY_PORT = 0;
    public static final int E_OK = 0;
    public static final int E_EOF = -1;
    public static final int E_ERROR = -2;
    public static final int E_BUFFER_FULL = -3;
    public static final int E_CLOSED = -4;
    public static final int E_NO_DATA = -5;
    public static final int E_INVALID_PORT = -6;
    public static final int E_SOCKET_ALLOCATION_FAILED = -7;
    public static final int E_ALREADY_JOIN = -8;
    public static final int E_PORT_IN_USE = -9;

    static {
        if (!NetworkConfiguration.initNetwork()) {
            throw new RuntimeException(Message.at((ErrorMessages)new ConnectionErrorMessages(), (int)13));
        }
    }

    public static boolean isIPAddress(String url) {
        if (url == null || url.length() == 0) {
            return false;
        }
        int lastIndexOfDot = 0;
        try {
            int indexOfDot = url.indexOf(46);
            NetworkDriver.checkIpElement(url.substring(0, indexOfDot));
            lastIndexOfDot = indexOfDot + 1;
            indexOfDot = url.indexOf(46, lastIndexOfDot);
            NetworkDriver.checkIpElement(url.substring(lastIndexOfDot, indexOfDot));
            lastIndexOfDot = indexOfDot + 1;
            indexOfDot = url.indexOf(46, lastIndexOfDot);
            NetworkDriver.checkIpElement(url.substring(lastIndexOfDot, indexOfDot));
            lastIndexOfDot = indexOfDot + 1;
            NetworkDriver.checkIpElement(url.substring(lastIndexOfDot));
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static int[] getNetworkInterfaces() {
        int nb = NetworkDriver.getNetworkInterfacesNumber();
        int[] interfaceNumbers = new int[nb];
        NetworkDriver.fillNetworkInterfacesIdentifiers(interfaceNumbers);
        return interfaceNumbers;
    }

    public static int openSocket(String host, int remotePort, boolean describedWithIP) throws IOException {
        int resourceId;
        if (!describedWithIP) {
            byte[] hostName = host.getBytes();
            resourceId = NetworkDriver.connectAddr(hostName, remotePort);
        } else {
            int remoteIpAddress;
            try {
                remoteIpAddress = NetworkDriver.extractIpAddress(host);
            }
            catch (Exception exception) {
                throw new IOException(Message.at((ErrorMessages)new ConnectionErrorMessages(), (int)10));
            }
            resourceId = NetworkDriver.connect(remoteIpAddress, remotePort);
        }
        if (resourceId < 0) {
            NetworkDriver.throwNewIOException(resourceId, 7);
        }
        return resourceId;
    }

    public static void closeSocket(int resourceId) {
        NetworkDriver.closeSocketNative(resourceId);
    }

    public static String getLocalAddressStr(int resourceId, boolean isServer) {
        int ip = NetworkDriver.getLocalAddress(resourceId, isServer);
        return NetworkDriver.buildIpAddress(ip);
    }

    public static String buildIpAddress(int addr) {
        int b3 = addr >> 24 & 0xFF;
        int b2 = addr >> 16 & 0xFF;
        int b1 = addr >> 8 & 0xFF;
        int b0 = addr & 0xFF;
        StringBuffer sb = new StringBuffer();
        sb.append(b3).append('.');
        sb.append(b2).append('.');
        sb.append(b1).append('.');
        sb.append(b0);
        return sb.toString();
    }

    public static int extractIpAddress(String humanReadableIpAddress) throws NumberFormatException {
        if (humanReadableIpAddress == null) {
            throw new NumberFormatException();
        }
        int lastIndexOfDot = 0;
        int address = 0;
        humanReadableIpAddress = humanReadableIpAddress.trim();
        int indexOfDot = humanReadableIpAddress.indexOf(46);
        int b = NetworkDriver.checkIpElement(humanReadableIpAddress.substring(0, indexOfDot));
        address += b << 24;
        lastIndexOfDot = indexOfDot + 1;
        indexOfDot = humanReadableIpAddress.indexOf(46, lastIndexOfDot);
        b = NetworkDriver.checkIpElement(humanReadableIpAddress.substring(lastIndexOfDot, indexOfDot));
        address += b << 16;
        lastIndexOfDot = indexOfDot + 1;
        indexOfDot = humanReadableIpAddress.indexOf(46, lastIndexOfDot);
        b = NetworkDriver.checkIpElement(humanReadableIpAddress.substring(lastIndexOfDot, indexOfDot));
        address += b << 8;
        lastIndexOfDot = indexOfDot + 1;
        b = NetworkDriver.checkIpElement(humanReadableIpAddress.substring(lastIndexOfDot));
        return address += b;
    }

    private static int checkIpElement(String number) {
        int value = Integer.parseInt(number);
        if (value > 255 || value < 0) {
            throw new NumberFormatException();
        }
        return value;
    }

    public static long getMacAddress(String addr) {
        int b;
        if (addr == null) {
            return -1L;
        }
        addr = addr.trim();
        addr = addr.replace('.', ':');
        addr = addr.replace('-', ':');
        int lastIndexOfDot = 0;
        int lsb = 0;
        int msb = 0;
        try {
            int indexOfDot = addr.indexOf(58);
            b = NetworkDriver.checkMacElement(addr.substring(0, indexOfDot));
            msb = (char)(msb + (b << 8));
            lastIndexOfDot = indexOfDot + 1;
            indexOfDot = addr.indexOf(58, lastIndexOfDot);
            b = NetworkDriver.checkMacElement(addr.substring(lastIndexOfDot, indexOfDot));
            msb = (char)(msb + b);
            lastIndexOfDot = indexOfDot + 1;
            indexOfDot = addr.indexOf(58, lastIndexOfDot);
            b = NetworkDriver.checkMacElement(addr.substring(lastIndexOfDot, indexOfDot));
            lsb += b << 24;
            lastIndexOfDot = indexOfDot + 1;
            indexOfDot = addr.indexOf(58, lastIndexOfDot);
            b = NetworkDriver.checkMacElement(addr.substring(lastIndexOfDot, indexOfDot));
            lsb += b << 16;
            lastIndexOfDot = indexOfDot + 1;
            indexOfDot = addr.indexOf(58, lastIndexOfDot);
            b = NetworkDriver.checkMacElement(addr.substring(lastIndexOfDot, indexOfDot));
            lsb += b << 8;
            lastIndexOfDot = indexOfDot + 1;
            b = NetworkDriver.checkMacElement(addr.substring(lastIndexOfDot));
        }
        catch (Exception exception) {
            return -1L;
        }
        long mac = msb;
        mac <<= 32;
        return mac |= (long)(lsb += b) & 0xFFFFFFFFL;
    }

    private static int checkMacElement(String number) {
        int value = Integer.parseInt(number, 16);
        if (value > 255 || value < 0) {
            throw new NumberFormatException();
        }
        return value;
    }

    public static void throwNewIOException(int errorCode, int errorMessageForE_ERROR) throws IOException {
        int messageId;
        int genericErrorCode = errorCode >> 16;
        short specificErrorCode = (short)errorCode;
        switch (genericErrorCode) {
            case -4: {
                throw new IOException(Message.at((ErrorMessages)new ej.ecom.support.err.ConnectionErrorMessages(), (int)1, (Object)new Integer(specificErrorCode)));
            }
            case -2: {
                messageId = errorMessageForE_ERROR;
                break;
            }
            case -6: {
                messageId = 15;
                break;
            }
            case -7: {
                messageId = 8;
                break;
            }
            case -9: {
                messageId = 6;
                break;
            }
            default: {
                messageId = 14;
            }
        }
        throw new IOException(Message.at((ErrorMessages)new ConnectionErrorMessages(), (int)messageId, (Object)new Integer(specificErrorCode)));
    }

    public static native int read(int var0);

    public static native int readBytes(int var0, byte[] var1, int var2, int var3);

    public static native int notBlockingRead(int var0);

    public static native int connect(int var0, int var1);

    public static native int write(int var0, int var1);

    public static native int writeBytes(int var0, byte[] var1, int var2, int var3);

    public static native void closeSocketNative(int var0);

    public static native void closeServer(int var0);

    public static native int getLocalAddress(int var0, boolean var1);

    public static native int getLocalPort(int var0, boolean var1);

    public static native int getRemotePort(int var0);

    public static native int getRemoteAddress(int var0);

    public static native int available(int var0);

    public static native long skip(int var0, long var1);

    public static native int flush(int var0);

    public static native int accept(int var0);

    public static native int createServerSocket(int var0, int var1);

    public static native int connectAddr(byte[] var0, int var1);

    public static native int getNetworkInterfacesNumber();

    public static native void fillNetworkInterfacesIdentifiers(int[] var0);

    public static native String getNetworkInterfaceName(int var0);

    public static native int getNetworkInterfaceId(String var0);

    public static native int getNetworkInterfaceIp(int var0);
}

