/*
 * Decompiled with CFR 0.152.
 */
package ej.ecom.connection.network;

import ej.ecom.connection.network.NetworkDriver;
import ej.ecom.connection.network.NetworkManager;
import java.io.IOException;

public class NetworkConfiguration {
    public static final int OPTIONAL_ADDR = -2;

    private static boolean initNetwork(String macString, String ipString, String maskString, String gatewayString, String dnsString) {
        long macAddress = NetworkDriver.getMacAddress(macString);
        int ip = 0;
        int mask = 0;
        int gateway = 0;
        int dns = -2;
        try {
            ip = NetworkDriver.extractIpAddress(ipString);
            mask = NetworkDriver.extractIpAddress(maskString);
            gateway = NetworkDriver.extractIpAddress(gatewayString);
            if (dnsString != null) {
                dns = NetworkDriver.extractIpAddress(dnsString);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return NetworkConfiguration.initializeNetwork(macAddress, ip, mask, gateway, dns, dns != -2);
    }

    public static boolean initNetwork() {
        int netIf = 0;
        NetworkManager config = NetworkManager.getNetworkManager();
        String macString = config.getMacAddressConfig(netIf);
        if (config.getDhcpConfig(netIf)) {
            return NetworkConfiguration.initializeNetworkDHCP(NetworkDriver.getMacAddress(macString));
        }
        try {
            return NetworkConfiguration.initNetwork(macString, config.getIpAddressConfig(netIf), config.getMaskAddressConfig(netIf), config.getGatewayAddressConfig(netIf), config.getDnsAddressConfig(netIf));
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static native boolean initializeNetwork(long var0, int var2, int var3, int var4, int var5, boolean var6);

    public static native boolean initializeNetworkDHCP(long var0);
}

