/*
 * Decompiled with CFR 0.152.
 */
package ej.ecom.connection;

import ej.error.ErrorMessages;

public class ConnectionErrorMessages
implements ErrorMessages {
    public static final int SocketAddressUnaccessible = 4;
    public static final int SocketLocalAddressUnaccessible = 5;
    public static final int SocketPortInUse = 6;
    public static final int SocketConnectionFailed = 7;
    public static final int SocketCreationError = 8;
    public static final int SocketURLNotDefined = 9;
    public static final int SocketHostNotFound = 10;
    public static final int SocketReceptionError = 11;
    public static final int SocketTransmissionError = 12;
    public static final int SocketNetworkInitializationError = 13;
    public static final int SocketError = 14;
    public static final int SocketInvalidPort = 15;
    public static final int InvalidNetworkInterface = 26;

    public String category() {
        return "ECOM-SOCKET";
    }

    public String messageAt(int index) {
        switch (index) {
            case 4: {
                return "Socket address unaccessible.";
            }
            case 5: {
                return "Socket local address unaccessible.";
            }
            case 6: {
                return "Socket port is already used.";
            }
            case 7: {
                return "Socket connection failed.";
            }
            case 8: {
                return "Socket creation error.";
            }
            case 9: {
                return "Socket URL not defined.";
            }
            case 10: {
                return "Socket host not found.";
            }
            case 11: {
                return "Socket reception error.";
            }
            case 12: {
                return "Socket transmission error.";
            }
            case 13: {
                return "Socket network initialization error.";
            }
            case 14: {
                return "Socket error.";
            }
            case 15: {
                return "Invalid port.";
            }
            case 26: {
                return "Invalid network interface.";
            }
        }
        return "Unknown error (" + index + ')';
    }
}

