/*
 * Decompiled with CFR 0.152.
 */
package ej.ecom.connection;

import ej.ecom.support.err.ConnectionErrorMessages;
import ej.error.ErrorMessages;
import ej.error.Message;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.StreamConnection;

public abstract class AbstractConnectionImpl
implements StreamConnection {
    protected final int resourceId;
    protected OutputStream outputStream;
    protected InputStream inputStream;
    protected byte closeState;
    protected static final byte NOT_CLOSED = 0;
    protected static final byte WANTS_TO_CLOSE = 1;
    protected static final byte CLOSED = 2;

    public AbstractConnectionImpl(int resourceId) {
        this.resourceId = resourceId;
    }

    public final synchronized InputStream openInputStream() throws IOException {
        if (this.closeState != 0) {
            throw new IOException(Message.at((ErrorMessages)new ConnectionErrorMessages(), (int)1));
        }
        if (this.inputStream != null) {
            throw new IOException(Message.at((ErrorMessages)new ConnectionErrorMessages(), (int)4));
        }
        this.inputStream = this.newInputStream();
        return this.inputStream;
    }

    public final synchronized OutputStream openOutputStream() throws IOException {
        if (this.closeState != 0) {
            throw new IOException(Message.at((ErrorMessages)new ConnectionErrorMessages(), (int)1));
        }
        if (this.outputStream != null) {
            throw new IOException(Message.at((ErrorMessages)new ConnectionErrorMessages(), (int)4));
        }
        this.outputStream = this.newOutputStream();
        return this.outputStream;
    }

    public final DataInputStream openDataInputStream() throws IOException {
        return new DataInputStream(this.openInputStream());
    }

    public final DataOutputStream openDataOutputStream() throws IOException {
        return new DataOutputStream(this.openOutputStream());
    }

    public final void close() throws IOException {
        if (this.closeState != 0) {
            return;
        }
        this.closeState = 1;
        this.tryInternalClose();
    }

    protected void tryInternalClose() throws IOException {
        if (this.inputStream == null && this.outputStream == null) {
            this.closeNative();
            this.closeState = (byte)2;
        }
    }

    protected abstract void closeNative() throws IOException;

    protected abstract InputStream newInputStream() throws IOException;

    protected abstract OutputStream newOutputStream() throws IOException;
}

