/*
 * Decompiled with CFR 0.152.
 */
package com.militsa.tools;

public final class BitManipulation {
    private BitManipulation() {
    }

    public static final int getInt(byte[] buf, int off, boolean isBigEndian) {
        byte i3 = buf[off];
        byte i2 = buf[++off];
        byte i1 = buf[++off];
        byte i0 = buf[++off];
        if (isBigEndian) {
            return i3 << 24 | (i2 & 0xFF) << 16 | (i1 & 0xFF) << 8 | i0 & 0xFF;
        }
        return i0 << 24 | (i1 & 0xFF) << 16 | (i2 & 0xFF) << 8 | i3 & 0xFF;
    }

    public static short getShort(byte[] buf, int off, boolean isBigEndian) {
        byte i1 = buf[off];
        byte i0 = buf[++off];
        if (isBigEndian) {
            return (short)((i1 & 0xFF) << 8 | i0 & 0xFF);
        }
        return (short)(i0 << 8 | i1 & 0xFF);
    }

    public static char getChar(byte[] buf, int off, boolean isBigEndian) {
        return (char)BitManipulation.getShort(buf, off, isBigEndian);
    }

    public static final long getLong(byte[] buf, int off, boolean isBigEndian) {
        int i0 = BitManipulation.getInt(buf, off, isBigEndian);
        int i1 = BitManipulation.getInt(buf, off + 4, isBigEndian);
        if (isBigEndian) {
            return (long)i0 << 32 | (long)i1 & 0xFFFFFFFFL;
        }
        return (long)i1 << 32 | (long)i0 & 0xFFFFFFFFL;
    }

    public static final void putShort(byte[] buf, int off, boolean isBigEndian, short value) {
        short low = value;
        int high = value >>> 8;
        if (isBigEndian) {
            buf[off] = (byte)high;
            buf[++off] = (byte)low;
        } else {
            buf[off] = (byte)low;
            buf[++off] = (byte)high;
        }
    }

    public static final void putInt(byte[] buf, int off, boolean isBigEndian, int value) {
        int i0 = value;
        int i1 = value >>> 8;
        int i2 = value >>> 16;
        int i3 = value >>> 24;
        if (isBigEndian) {
            buf[off] = (byte)i3;
            buf[++off] = (byte)i2;
            buf[++off] = (byte)i1;
            buf[++off] = (byte)i0;
        } else {
            buf[off] = (byte)i0;
            buf[++off] = (byte)i1;
            buf[++off] = (byte)i2;
            buf[++off] = (byte)i3;
        }
    }

    public static final void putLong(byte[] buf, int off, boolean isBigEndian, long value) {
        int high = (int)(value >>> 32);
        int low = (int)value;
        BitManipulation.putInt(buf, off, isBigEndian, isBigEndian ? high : low);
        BitManipulation.putInt(buf, off + 4, isBigEndian, isBigEndian ? low : high);
    }
}

