/*
 * Decompiled with CFR 0.152.
 */
package com.ist.debug.support;

import com.ist.debug.DebugThread;
import com.ist.debug.EventAndRequestProductionTools;
import com.militsa.tools.BitManipulation;
import java.io.IOException;
import java.io.OutputStream;

public class Reply {
    private static final int HEADER_SIZE = 11;
    private static final int SIZE_INCREMENT = 512;
    private final byte[] header;
    private byte[] data;
    private int offset;

    public Reply(byte[][] buffers, int id) {
        this.header = buffers[0];
        BitManipulation.putInt(this.header, 4, true, id);
        this.header[8] = -128;
        this.data = buffers[1];
        this.offset = 0;
        this.setError((short)0);
    }

    private void resizeBuffer(int dataSize) {
        if (this.offset + dataSize >= this.data.length) {
            this.data = new byte[this.data.length + 512];
        }
    }

    public void putByte(byte value) {
        this.resizeBuffer(1);
        this.data[this.offset] = value;
        ++this.offset;
    }

    public void putBoolean(boolean value) {
        this.resizeBuffer(1);
        this.data[this.offset] = (byte)(value ? 1 : 0);
        ++this.offset;
    }

    public void putShort(short value) {
        this.resizeBuffer(2);
        BitManipulation.putShort(this.data, this.offset, true, value);
        this.offset += 2;
    }

    public void putInt(int value) {
        this.resizeBuffer(4);
        BitManipulation.putInt(this.data, this.offset, true, value);
        this.offset += 4;
    }

    public void setInt(int value, int offset) {
        BitManipulation.putInt(this.data, offset, true, value);
    }

    public void putLong(long value) {
        this.resizeBuffer(8);
        BitManipulation.putLong(this.data, this.offset, true, value);
        this.offset += 8;
    }

    public void putString(String string) {
        if (string == null) {
            string = "null";
        }
        this.putBytes(string.getBytes());
    }

    public void putBytes(byte[] bytes) {
        this.resizeBuffer(4 + bytes.length);
        BitManipulation.putInt(this.data, this.offset, true, bytes.length);
        this.offset += 4;
        if (bytes.length != 0) {
            System.arraycopy(bytes, 0, this.data, this.offset, bytes.length);
        }
        this.offset += bytes.length;
    }

    public void setError(short errorCode) {
        BitManipulation.putShort(this.header, 9, true, errorCode);
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void skip(int length) {
        this.offset += length;
    }

    public void send() {
        block7: {
            int replyLength = 11 + this.offset;
            BitManipulation.putInt(this.header, 0, true, replyLength);
            if (replyLength > 0) {
                OutputStream os;
                if (DebugThread.VERBOSE) {
                    DebugThread.debug("REPLY");
                    EventAndRequestProductionTools.debugBuffer("HEADER", this.header, 11);
                }
                if ((os = DebugThread.INSTANCE.outputStream) == null) {
                    return;
                }
                try {
                    os.write(this.header);
                    if (replyLength <= 11) break block7;
                    os.write(this.data, 0, replyLength - 11);
                    if (!DebugThread.VERBOSE) break block7;
                    if (replyLength < 250) {
                        EventAndRequestProductionTools.debugBuffer("DATA", this.data, replyLength - 11);
                        break block7;
                    }
                    EventAndRequestProductionTools.debugBuffer("DATA", this.data, 50);
                }
                catch (IOException iOException) {}
            } else {
                DebugThread.debug("NO REPLY");
            }
        }
    }
}

