/*
 * Decompiled with CFR 0.152.
 */
package com.ist.debug.reqMgr.event;

import com.ist.debug.reqMgr.event.EventDispatcher;
import com.ist.debug.reqMgr.event.EventModifier;
import com.ist.debug.reqMgr.event.InvalidEventRequestException;
import com.militsa.tools.BitManipulation;

public class ExceptionOnlyEventModifier
extends EventModifier {
    int exceptionTypeID;
    boolean caught;
    boolean uncaught;

    public ExceptionOnlyEventModifier(int eventID, byte[] dataBuf, int offset) {
        super(eventID, dataBuf, offset);
    }

    public int readModifier() {
        byte[] buf = this.dataBuf;
        int offset = this.offset;
        this.exceptionTypeID = BitManipulation.getInt(buf, offset, true) - 1;
        offset += 4;
        this.caught = buf[offset++] == 1;
        this.uncaught = buf[offset++] == 1;
        short errorCode = EventDispatcher.addExceptionOnlyModifier(this.evReqID, this.exceptionTypeID, this.caught, this.uncaught);
        if (errorCode != 0) {
            throw new InvalidEventRequestException(errorCode);
        }
        return offset;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ExceptionOnly modifier - typeID=").append(this.exceptionTypeID).append(" caught=").append(this.caught).append(" uncaught=").append(this.uncaught);
        return sb.toString();
    }
}

