/*
 * Decompiled with CFR 0.152.
 */
package com.ist.debug.reqMgr.event;

import com.ist.debug.DebugState;
import com.ist.debug.DebugThread;
import com.ist.debug.DebugThreadException;
import com.ist.debug.EventAndRequestProductionTools;
import com.ist.debug.EventAndRequestState;
import com.ist.debug.RequestCounter;
import com.ist.debug.reqMgr.RequestManager;
import com.militsa.tools.BitManipulation;
import java.io.IOException;
import java.io.OutputStream;
import jdwp.ISTEvents;
import jdwp.Location;
import jdwp.Value;

public class EventDispatcher
implements ISTEvents {
    private static final int EVENT_DATA_SIZE = 250;
    private static final int EVENT_DATA_MIN_LENGTH = 5;
    private static final int EVENT_KIND_OFFSET = 0;
    private static final int MAX_EVENT_DATA_SIZE = 200;
    private final char[] charBuffer = new char[200];
    private final DebugState debugState;
    private int eventDataLastEventOffset;
    private int eventDataCurrentLength = 5;
    private int nbEvents;
    private static byte[][] eventCommandBuffers;
    private int[][] eventRules;
    private static final int EVENT_RULE_MASK_IDX = 0;
    private static final int EVENT_RULE_COMPARE_ZONE_OFFSET_IDX = 1;
    private static final int EVENT_RULE_COMPARE_ZONE_SIZE_IDX = 2;
    private int lastEventMask = -1;
    private byte compositeEventSuspendPolicy;
    private int sendThreadId = -1;
    private final byte[] data;
    private final Location location;
    private final Value value;

    public EventDispatcher(EventAndRequestState debugState) {
        this.debugState = debugState;
        this.data = new byte[200];
        this.location = new Location();
        this.value = new Value();
        eventCommandBuffers = new byte[2][];
        EventDispatcher.eventCommandBuffers[0] = new byte[11];
        EventDispatcher.eventCommandBuffers[1] = new byte[250];
    }

    private final void resetNbEvents() {
        this.eventDataCurrentLength = 5;
        this.nbEvents = 0;
    }

    private final int finalizeEventBuffer() {
        byte[] buf = eventCommandBuffers[0];
        RequestManager.writeRequestHeader(buf, 11 + this.eventDataCurrentLength, RequestCounter.INSTANCE.incr(), (byte)64, (byte)100);
        buf = eventCommandBuffers[1];
        buf[0] = this.compositeEventSuspendPolicy;
        this.compositeEventSuspendPolicy = 0;
        this.sendThreadId = -1;
        BitManipulation.putInt(buf, 1, true, this.nbEvents);
        return this.eventDataCurrentLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void sendEvents() {
        if (this.nbEvents == 0) {
            return;
        }
        if (this.compositeEventSuspendPolicy == 1) {
            EventAndRequestState.resumeThread(this.sendThreadId, this.nbEvents - 1);
        } else if (this.compositeEventSuspendPolicy == 2) {
            EventAndRequestState.resumeVM(this.nbEvents - 1);
        }
        DebugThread.debug("Sending " + this.nbEvents + " event(s) on network");
        int dataLength = this.finalizeEventBuffer();
        OutputStream s = this.debugState.dt.outputStream;
        Object object = RequestManager.lock;
        synchronized (object) {
            try {
                if (DebugThread.VERBOSE) {
                    EventAndRequestProductionTools.debugBuffer("HEADER", eventCommandBuffers[0], 11);
                }
                s.write(eventCommandBuffers[0]);
            }
            catch (IOException e) {
                DebugThread.error("IOException while sending events (header)", e);
                throw new DebugThreadException("IOException while sending events");
            }
            try {
                if (DebugThread.VERBOSE) {
                    EventAndRequestProductionTools.debugBuffer("DATA", eventCommandBuffers[1], dataLength);
                }
                s.write(eventCommandBuffers[1], 0, dataLength);
            }
            catch (IOException e) {
                DebugThread.error("IOException while sending events (data)", e);
                throw new DebugThreadException("IOException while sending events");
            }
        }
        this.lastEventMask = -1;
        this.resetNbEvents();
    }

    public static native int eventRequest(int var0, byte var1, byte var2);

    public static native void clearRequest(int var0, int var1);

    public static native void clearAllRequests(int var0);

    public static native short addCountModifier(int var0, int var1);

    public static native short addThreadOnlyModifier(int var0, int var1);

    public static native short addClassOnlyModifier(int var0, int var1);

    public static native short addClassMatchModifier(int var0, String var1);

    public static native short addClassExcludeModifier(int var0, String var1);

    public static native short addLocationOnlyModifier(int var0, byte var1, int var2, int var3, int var4, long var5);

    public static native short addExceptionOnlyModifier(int var0, int var1, boolean var2, boolean var3);

    public static native short addFieldOnlyModifier(int var0, int var1, int var2);

    public static native short addStepModifier(int var0, int var1, int var2, int var3);

    public static native short addInstanceOnlyModifier(int var0, int var1);

    public static native short finalizeEventRequest(int var0);

    public native void produceEvents();

    private synchronized void eventProduced(int eventID, int threadId, byte[] eventData, int dataSize, int suspendPolicy, int last) {
        byte[] buf = eventCommandBuffers[1];
        this.sendThreadId = threadId;
        int newLength = this.eventDataCurrentLength + dataSize;
        if (newLength >= buf.length) {
            byte[] newBuf = new byte[newLength + newLength / 2];
            System.arraycopy(buf, 0, newBuf, 0, buf.length);
            buf = newBuf;
            EventDispatcher.eventCommandBuffers[1] = buf;
        }
        System.arraycopy(eventData, 0, buf, this.eventDataCurrentLength, dataSize);
        this.eventDataLastEventOffset = this.eventDataCurrentLength;
        this.eventDataCurrentLength += dataSize;
        ++this.nbEvents;
        this.compositeEventSuspendPolicy = (byte)suspendPolicy;
        if (last > 0) {
            this.sendEvents();
        }
    }

    public void produceVMStartEvent(int reqID, int thrID, int suspendPolicy, int last) {
        DebugThread.debug("let's produce a VM_START event");
        byte[] data = this.data;
        data[0] = 90;
        BitManipulation.putInt(data, 1, true, reqID);
        BitManipulation.putInt(data, 5, true, thrID);
        this.eventProduced(0, thrID, data, 9, suspendPolicy, last);
    }

    public void produceVMDeathEvent(int reqID, int suspendPolicy, int last) {
        DebugThread.debug("let's produce a VM_DEATH event");
        byte[] data = this.data;
        data[0] = 99;
        BitManipulation.putInt(data, 1, true, reqID);
        this.eventProduced(1, -1, data, 5, suspendPolicy, last);
    }

    public void produceThreadStartEvent(int reqID, int thrID, int suspendPolicy, int last) {
        DebugThread.debug("VM wants to produce a THREAD_START event");
        byte[] data = this.data;
        data[0] = 6;
        BitManipulation.putInt(data, 1, true, reqID);
        BitManipulation.putInt(data, 5, true, thrID);
        this.eventProduced(2, thrID, data, 9, suspendPolicy, last);
    }

    public void produceSingleStepEvent(int reqID, int threadID, byte typeTag, int classID, int realMethodClassID, int methodID, long index, int suspendPolicy, int last) {
        DebugThread.debug("VM wants to produce a SINGLE_STEP event");
        byte[] data = this.data;
        data[0] = 1;
        int off = 1;
        BitManipulation.putInt(data, off, true, reqID);
        BitManipulation.putInt(data, off += 4, true, threadID);
        this.location.init(typeTag, classID, realMethodClassID, methodID, index).put(data, off += 4);
        this.eventProduced(10, threadID, data, 30, suspendPolicy, last);
    }

    public void produceBreakpointEvent(int reqID, int threadID, byte typeTag, int classID, int realMethodClassID, int methodID, long index, int suspendPolicy, int last) {
        DebugThread.debug("VM wants to produce a BREAKPOINT event");
        byte[] data = this.data;
        data[0] = 2;
        int off = 1;
        BitManipulation.putInt(data, off, true, reqID);
        BitManipulation.putInt(data, off += 4, true, threadID);
        this.location.init(typeTag, classID, realMethodClassID, methodID, index).put(data, off += 4);
        this.eventProduced(9, threadID, data, 30, suspendPolicy, last);
    }

    public void produceMethodEntryEvent(int reqID, int threadID, byte typeTag, int classID, int realMethodClassID, int methodID, long index, int suspendPolicy, int last) {
        DebugThread.debug("VM wants to produce a METHOD_ENTRY event");
        byte[] data = this.data;
        data[0] = 40;
        int off = 1;
        BitManipulation.putInt(data, off, true, reqID);
        BitManipulation.putInt(data, off += 4, true, threadID);
        this.location.init(typeTag, classID, realMethodClassID, methodID, index).put(data, off += 4);
        this.eventProduced(11, threadID, data, 30, suspendPolicy, last);
    }

    public void produceMethodExitEvent(int reqID, int threadID, byte typeTag, int classID, int realMethodClassID, int methodID, long index, int suspendPolicy, int last) {
        DebugThread.debug("VM wants to produce a METHOD_EXIT event");
        byte[] data = this.data;
        data[0] = 41;
        int off = 1;
        BitManipulation.putInt(data, off, true, reqID);
        BitManipulation.putInt(data, off += 4, true, threadID);
        this.location.init(typeTag, classID, realMethodClassID, methodID, index).put(data, off += 4);
        this.eventProduced(12, threadID, data, 30, suspendPolicy, last);
    }

    public void produceExceptionEvent(int reqID, int threadID, byte typeTag, int classID, int realMethodClassID, int methodID, long index, byte tag, int objectID, byte typeTagC, int classIDC, int realMethodClassIDC, int methodIDC, long indexC, int suspendPolicy, int last) {
        DebugThread.debug("VM wants to produce a EXCEPTION event");
        byte[] data = this.data;
        data[0] = 4;
        int off = 1;
        BitManipulation.putInt(data, off, true, reqID);
        BitManipulation.putInt(data, off += 4, true, threadID);
        off += 4;
        off = this.location.init(typeTag, classID, realMethodClassID, methodID, index).put(data, off);
        data[off] = tag;
        BitManipulation.putInt(data, ++off, true, objectID);
        this.location.init(typeTagC, classIDC, realMethodClassIDC, methodIDC, indexC).put(data, off += 4);
        this.eventProduced(8, threadID, data, 56, suspendPolicy, last);
    }

    public void produceThreadDeathEvent(int reqID, int threadID, int suspendPolicy, int last) {
        DebugThread.debug("VM wants to produce a THREAD_DEATH event");
        byte[] data = this.data;
        data[0] = 7;
        int off = 1;
        BitManipulation.putInt(data, off, true, reqID);
        BitManipulation.putInt(data, off += 4, true, threadID);
        this.eventProduced(3, threadID, data, 9, suspendPolicy, last);
    }

    public void produceClassPrepareEvent(int reqID, int threadID, byte refTypeTag, int refTypeID, int signatureSize, int status, int suspendPolicy, int last) {
        String signature = new String(this.charBuffer, 0, signatureSize);
        DebugThread.debug("VM wants to produce a CLASS_PREPARE event for class " + signature);
        byte[] data = this.data;
        data[0] = 8;
        int off = 1;
        BitManipulation.putInt(data, off, true, reqID);
        BitManipulation.putInt(data, off += 4, true, threadID);
        data[off += 4] = refTypeTag;
        BitManipulation.putInt(data, ++off, true, refTypeID + 1);
        off += 4;
        off = EventAndRequestProductionTools.writeString(data, off, signature);
        BitManipulation.putInt(data, off, true, status);
        this.eventProduced(4, threadID, data, off += 4, suspendPolicy, last);
    }

    public void produceClassUnloadEvent(int reqID, int signatureSize, int suspendPolicy, int last) {
        String signature = new String(this.charBuffer, 0, signatureSize);
        DebugThread.debug("VM wants to produce a CLASS_UNLOAD event for class " + signature);
        byte[] data = this.data;
        data[0] = 9;
        int off = 1;
        BitManipulation.putInt(data, off, true, reqID);
        off += 4;
        off = EventAndRequestProductionTools.writeString(data, off, signature);
        this.eventProduced(5, -1, data, off, suspendPolicy, last);
    }

    public void produceFieldAccessEvent(int reqID, int threadID, byte typeTag, int classID, int realMethodClassID, int methodID, long index, byte refTypeTag, int refTypeID, int fieldID, byte tag, int objectID, int suspendPolicy, int last) {
        DebugThread.debug("VM wants to produce a FIELD_ACCESS event");
        byte[] data = this.data;
        data[0] = 20;
        int off = 1;
        BitManipulation.putInt(data, off, true, reqID);
        BitManipulation.putInt(data, off += 4, true, threadID);
        off += 4;
        off = this.location.init(typeTag, classID, realMethodClassID, methodID, index).put(data, off);
        data[off] = typeTag;
        BitManipulation.putInt(data, ++off, true, refTypeID + 1);
        BitManipulation.putInt(data, off += 4, true, refTypeID + 1);
        BitManipulation.putInt(data, off + 4, true, fieldID);
        data[off += 8] = tag;
        BitManipulation.putInt(data, ++off, true, objectID);
        this.eventProduced(6, threadID, data, off += 4, suspendPolicy, last);
    }

    public void produceFieldModificationEvent(int reqID, int threadID, byte typeTag, int classID, int realMethodClassID, int methodID, long index, byte refTypeTag, int refTypeID, int fieldID, byte tag, int objectID, byte valTag, long val, int suspendPolicy, int last) {
        DebugThread.debug("VM wants to produce a FIELD_MODIFICATION event");
        byte[] data = this.data;
        data[0] = 21;
        int off = 1;
        BitManipulation.putInt(data, off, true, reqID);
        BitManipulation.putInt(data, off += 4, true, threadID);
        off += 4;
        off = this.location.init(typeTag, classID, realMethodClassID, methodID, index).put(data, off);
        data[off] = typeTag;
        BitManipulation.putInt(data, ++off, true, refTypeID + 1);
        BitManipulation.putInt(data, off += 4, true, refTypeID + 1);
        BitManipulation.putInt(data, off + 4, true, fieldID);
        data[off += 8] = tag;
        BitManipulation.putInt(data, ++off, true, objectID);
        off += 4;
        this.value.init(valTag, val);
        off = this.value.put(data, off, true);
        this.eventProduced(7, threadID, data, off, suspendPolicy, last);
    }
}

