/*
 * Decompiled with CFR 0.152.
 */
package com.ist.debug.reqMgr;

import com.ist.debug.EventAndRequestState;
import com.ist.debug.reqMgr.RequestManager;
import com.ist.debug.reqMgr.RequestMediator;
import com.ist.debug.support.Reply;

public class VMClasspathsRequestManager
extends RequestManager {
    public VMClasspathsRequestManager(RequestMediator mediator) {
        super(mediator);
    }

    public void manageRequest(int requestId, int length, byte[][] buffers) {
        int start;
        int index;
        String bootpath = EventAndRequestState.getBootClasspath();
        String classpath = EventAndRequestState.getClasspath();
        String basedir = System.getProperty("user.dir");
        char pathsep = System.getProperty("path.separator").charAt(0);
        Reply reply = new Reply(buffers, requestId);
        if (basedir != null) {
            reply.putString(basedir);
        } else {
            reply.putInt(0);
        }
        int nbPathEltOffset = reply.getOffset();
        reply.skip(4);
        int count = 0;
        if (classpath != null) {
            index = 0;
            int classpathLength = classpath.length();
            while (index < classpathLength) {
                start = index;
                if ((index = classpath.indexOf(pathsep, index + 1)) == -1) break;
                String cpElem = classpath.substring(start, index);
                reply.putString(cpElem);
                ++count;
            }
        }
        reply.setInt(count, nbPathEltOffset);
        nbPathEltOffset = reply.getOffset();
        reply.skip(4);
        count = 0;
        if (bootpath != null) {
            index = 0;
            int bootpathLength = bootpath.length();
            while (index < bootpathLength) {
                start = index;
                if ((index = bootpath.indexOf(pathsep, index + 1)) == -1) break;
                String bpElem = bootpath.substring(start, index);
                reply.putString(bpElem);
                ++count;
            }
        }
        reply.setInt(count, nbPathEltOffset);
        reply.send();
    }
}

