/*
 * Decompiled with CFR 0.152.
 */
package com.ist.debug.reqMgr;

import com.ist.debug.reqMgr.RequestManager;
import com.ist.debug.reqMgr.RequestMediator;
import com.ist.debug.support.Reply;

public class VMClasspaths
extends RequestManager {
    public VMClasspaths(RequestMediator mediator) {
        super(mediator);
    }

    public void manageRequest(int requestId, int length, byte[][] buffers) {
        int start;
        int index;
        String bootpath = System.getProperty("sun.boot.class.path");
        String classpath = System.getProperty("java.class.path");
        String basedir = System.getProperty("user.dir");
        char pathsep = System.getProperty("path.separator").charAt(0);
        Reply reply = new Reply(buffers, requestId);
        if (basedir != null) {
            reply.putString(basedir);
        } else {
            reply.putInt(0);
        }
        int nbPathEltOffset = reply.getOffset();
        reply.skip(4);
        int count = 0;
        if (classpath != null) {
            index = 0;
            length = classpath.length();
            while (index < length) {
                start = index;
                if ((index = classpath.indexOf(pathsep, index + 1)) != -1) {
                    reply.putString(classpath.substring(start, index));
                    ++count;
                    continue;
                }
                break;
            }
        } else {
            reply.putInt(0);
        }
        reply.setInt(count, nbPathEltOffset);
        nbPathEltOffset = reply.getOffset();
        reply.skip(4);
        count = 0;
        if (bootpath != null) {
            reply.skip(1);
            index = 0;
            length = bootpath.length();
            while (index < length) {
                start = index;
                if ((index = bootpath.indexOf(pathsep, index + 1)) != -1) {
                    reply.putString(bootpath.substring(start, index));
                    ++count;
                    continue;
                }
                break;
            }
        } else {
            reply.putInt(0);
        }
        reply.setInt(count, nbPathEltOffset);
        reply.send();
    }
}

