/*
 * Decompiled with CFR 0.152.
 */
package com.ist.debug.reqMgr;

import com.ist.debug.EventAndRequestState;
import com.ist.debug.reqMgr.RequestManager;
import com.ist.debug.reqMgr.RequestMediator;
import com.ist.debug.support.Reply;
import com.militsa.tools.BitManipulation;

public class ThreadStatusRequestManager
extends RequestManager {
    private static final String[] thStatStr = new String[]{"ZOMBIE", "RUNNING", "SLEEP", "MONITOR", "WAIT"};
    private int threadID;
    private int threadStatus = -1;
    private int suspendStatus = -1;

    public ThreadStatusRequestManager(RequestMediator mediator) {
        super(mediator);
    }

    public void manageRequest(int requestId, int length, byte[][] buffers) {
        byte[] buf = buffers[1];
        this.threadID = BitManipulation.getInt(buf, 0, true);
        Reply reply = new Reply(buffers, requestId);
        int status = EventAndRequestState.getThreadStatus(this.threadID);
        if (status >= 0) {
            this.threadStatus = status & 7;
            this.suspendStatus = status >> 3 & 1;
            reply.putInt(this.threadStatus);
            reply.putInt(this.suspendStatus);
        } else {
            reply.setError((short)10);
        }
        reply.send();
    }

    public String toString() {
        String str = super.toString();
        if (this.suspendStatus == -1) {
            return String.valueOf(str) + "for thread " + this.threadID + " (invalid thread)";
        }
        return String.valueOf(str) + "for thread " + this.threadID + " => " + thStatStr[this.threadStatus] + (this.suspendStatus == 0 ? "" : " and suspended");
    }
}

