/*
 * Decompiled with CFR 0.152.
 */
package com.ist.debug.reqMgr;

import com.ist.debug.EventAndRequestState;
import com.ist.debug.reqMgr.RequestManager;
import com.ist.debug.reqMgr.RequestMediator;
import com.ist.debug.support.Reply;
import com.militsa.tools.BitManipulation;

public class ThreadNameRequestManager
extends RequestManager {
    private int threadID;
    private String name;

    public ThreadNameRequestManager(RequestMediator mediator) {
        super(mediator);
    }

    public void manageRequest(int requestId, int length, byte[][] buffers) {
        byte[] buf = buffers[1];
        this.threadID = BitManipulation.getInt(buf, 0, true);
        int error = 0;
        int threadNameId = EventAndRequestState.getThreadNameID(this.threadID);
        if (threadNameId == -1) {
            error = 10;
        } else if (threadNameId == 0) {
            this.name = "anonymous";
        } else {
            int sLength = EventAndRequestState.getStringLength(threadNameId);
            if (sLength < 0) {
                error = 506;
            } else {
                byte[] threadName = new byte[sLength];
                if (!EventAndRequestState.getStringChars(threadNameId, threadName, 0)) {
                    error = 506;
                } else {
                    this.name = new String(threadName);
                }
            }
        }
        Reply reply = new Reply(buffers, requestId);
        reply.putString(this.name);
        reply.setError((short)error);
        reply.send();
    }

    public String toString() {
        return String.valueOf(super.toString()) + "for thread " + this.threadID + " => " + this.name;
    }
}

