/*
 * Decompiled with CFR 0.152.
 */
package com.ist.debug.reqMgr;

import com.ist.debug.DebugThread;
import com.ist.debug.EventAndRequestState;
import com.ist.debug.reqMgr.RequestManager;
import com.ist.debug.reqMgr.RequestMediator;
import com.ist.debug.support.Reply;
import com.militsa.tools.BitManipulation;
import jdwp.Location;

public class ThreadFramesRequestManager
extends RequestManager {
    private int threadID;
    private int nbFrames;
    private int startFrame;

    public ThreadFramesRequestManager(RequestMediator mediator) {
        super(mediator);
    }

    public void manageRequest(int requestId, int length, byte[][] buffers) {
        byte[] buf = buffers[1];
        int offset = 0;
        this.threadID = BitManipulation.getInt(buf, offset, true);
        this.startFrame = BitManipulation.getInt(buf, offset += 4, true);
        int error = 0;
        this.nbFrames = BitManipulation.getInt(buf, offset += 4, true);
        int nbFrames = this.nbFrames;
        if (nbFrames == -1) {
            nbFrames = EventAndRequestState.getNbStackFrames(this.threadID);
            if (nbFrames == -1) {
                error = 10;
            } else {
                nbFrames -= this.startFrame;
            }
        }
        if (nbFrames > 1000) {
            nbFrames = 1000;
        }
        Reply reply = new Reply(buffers, requestId);
        if (error == 0) {
            int framesLength = 6 * nbFrames;
            long[] frames = new long[framesLength];
            int noRetrievedFrames = EventAndRequestState.getFrames(this.threadID, frames, this.startFrame, nbFrames);
            if (noRetrievedFrames < 0) {
                reply.putInt(0);
                error = 10;
            } else {
                if (noRetrievedFrames < nbFrames) {
                    DebugThread.debug("Retrieved " + (nbFrames - noRetrievedFrames) + " less frames than requested");
                }
                reply.putInt(nbFrames);
                int i = 0;
                while (i < framesLength) {
                    reply.putInt(this.threadID);
                    reply.putInt((int)frames[i]);
                    new Location((byte)frames[++i], (int)frames[++i], (int)frames[++i], (int)frames[++i], frames[++i]).put(reply);
                    ++i;
                }
            }
        }
        reply.setError((short)error);
        reply.send();
    }

    public String toString() {
        return String.valueOf(super.toString()) + "for thread " + this.threadID + " : startFrame=" + this.startFrame + " nbFrame=" + this.nbFrames;
    }
}

