/*
 * Decompiled with CFR 0.152.
 */
package com.ist.debug.reqMgr;

import com.ist.debug.EventAndRequestState;
import com.ist.debug.reqMgr.RequestManager;
import com.ist.debug.reqMgr.RequestMediator;
import com.ist.debug.support.Reply;
import com.militsa.tools.BitManipulation;

public class ThreadFrameCountManager
extends RequestManager {
    private int threadId;
    private int nbFrames;

    public ThreadFrameCountManager(RequestMediator mediator) {
        super(mediator);
    }

    public void manageRequest(int requestId, int length, byte[][] buffers) {
        byte[] buf = buffers[1];
        this.threadId = BitManipulation.getInt(buf, 0, true);
        Reply reply = new Reply(buffers, requestId);
        int nbFrames = EventAndRequestState.getNbStackFrames(this.threadId);
        if (nbFrames == -1) {
            reply.setError((short)10);
        }
        reply.putInt(nbFrames);
        reply.send();
    }

    public String toString() {
        return String.valueOf(super.toString()) + "for thread " + this.threadId + " nb of frames=" + this.nbFrames;
    }
}

