/*
 * Decompiled with CFR 0.152.
 */
package com.ist.debug.reqMgr;

import com.ist.debug.EventAndRequestState;
import com.ist.debug.reqMgr.RequestManager;
import com.ist.debug.reqMgr.RequestMediator;
import com.ist.debug.support.Reply;
import com.militsa.tools.BitManipulation;

public class StringValueRequestManager
extends RequestManager {
    private int stringId;

    public StringValueRequestManager(RequestMediator mediator) {
        super(mediator);
    }

    public void manageRequest(int requestId, int length, byte[][] buffers) {
        byte[] buf = buffers[1];
        int stringID = BitManipulation.getInt(buf, 0, true);
        Reply reply = new Reply(buffers, requestId);
        int sLength = EventAndRequestState.getStringLength(stringID);
        if (sLength < 0) {
            reply.setError((short)506);
        } else {
            byte[] value = new byte[sLength];
            if (!EventAndRequestState.getStringChars(stringID, value, 0)) {
                reply.setError((short)506);
            } else {
                reply.putBytes(value);
            }
        }
        reply.send();
    }

    public String toString() {
        return String.valueOf(super.toString()) + "for string " + this.stringId;
    }
}

