/*
 * Decompiled with CFR 0.152.
 */
package com.ist.debug.reqMgr;

import com.ist.debug.EventAndRequestState;
import com.ist.debug.reqMgr.RequestManager;
import com.ist.debug.reqMgr.RequestMediator;
import com.ist.debug.support.Reply;
import com.militsa.tools.BitManipulation;

public class ReferenceSourceFileRequestManager
extends RequestManager {
    private int refType;
    private String sourceFile;

    public ReferenceSourceFileRequestManager(RequestMediator mediator) {
        super(mediator);
    }

    public void manageRequest(int requestId, int length, byte[][] buffers) {
        byte[] buf = buffers[1];
        this.refType = BitManipulation.getInt(buf, 0, true) - 1;
        Reply reply = new Reply(buffers, requestId);
        if (EventAndRequestState.getTypeTag(this.refType) == 3) {
            reply.setError((short)101);
        } else {
            int internalString = EventAndRequestState.sourceFile(this.refType);
            if (internalString < 0) {
                reply.setError((short)21);
            } else {
                this.sourceFile = EventAndRequestState.getInternalName(internalString);
                if (this.sourceFile == null) {
                    reply.putBytes(null);
                } else {
                    reply.putBytes(this.sourceFile.getBytes());
                }
            }
        }
        reply.send();
    }

    public String toString() {
        return String.valueOf(super.toString()) + "for type " + this.refType + " => " + this.sourceFile;
    }
}

