/*
 * Decompiled with CFR 0.152.
 */
package com.ist.debug.reqMgr;

import com.ist.debug.EventAndRequestState;
import com.ist.debug.reqMgr.RequestManager;
import com.ist.debug.reqMgr.RequestMediator;
import com.ist.debug.support.Reply;
import com.militsa.tools.BitManipulation;

public class ReferenceSignatureRequestManager
extends RequestManager {
    private int typeID;
    private String typeName;

    public ReferenceSignatureRequestManager(RequestMediator mediator) {
        super(mediator);
    }

    public void manageRequest(int requestId, int length, byte[][] buffers) {
        byte[] buf = buffers[1];
        this.typeID = BitManipulation.getInt(buf, 0, true) - 1;
        byte[] buffer = EventAndRequestState.getTypeSignatureByTypeID(this.typeID);
        this.typeName = new String(buffer);
        Reply reply = new Reply(buffers, requestId);
        if (buffer == null) {
            reply.setError((short)20);
        } else {
            reply.putBytes(buffer);
        }
        reply.send();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("for type ");
        sb.append(this.typeID);
        if (this.typeName != null) {
            sb.append("->");
            sb.append(this.typeName);
        }
        return sb.toString();
    }
}

