/*
 * Decompiled with CFR 0.152.
 */
package com.ist.debug.reqMgr;

import com.ist.debug.EventAndRequestState;
import com.ist.debug.reqMgr.RequestManager;
import com.ist.debug.reqMgr.RequestMediator;
import com.ist.debug.support.Reply;
import com.militsa.tools.BitManipulation;

public class ReferenceMethodsRequestManager
extends RequestManager {
    private int refId;

    public ReferenceMethodsRequestManager(RequestMediator mediator) {
        super(mediator);
    }

    public void manageRequest(int requestId, int length, byte[][] buffers) {
        byte[] buf = buffers[1];
        int refID = this.refId = BitManipulation.getInt(buf, 0, true) - 1;
        int nbMethods = EventAndRequestState.getNbMethodsLocally(refID);
        Reply reply = new Reply(buffers, requestId);
        boolean error = false;
        switch (nbMethods) {
            case -1: {
                reply.setError((short)21);
                error = true;
                break;
            }
            case -2: {
                reply.setError((short)22);
                error = true;
            }
        }
        if (error) {
            reply.putInt(0);
        } else {
            reply.putInt(nbMethods);
            int i = 0;
            while (i < nbMethods) {
                reply.putInt(refID + 1);
                reply.putInt(i);
                reply.putBytes(EventAndRequestState.getMethodName(refID, i));
                reply.putBytes(EventAndRequestState.getMethodSignature(refID, i));
                reply.putInt(EventAndRequestState.getMethodModBits(refID, i));
                ++i;
            }
        }
        reply.send();
    }

    public String toString() {
        return String.valueOf(super.toString()) + "for type " + this.refId;
    }
}

