/*
 * Decompiled with CFR 0.152.
 */
package com.ist.debug.reqMgr;

import com.ist.debug.EventAndRequestState;
import com.ist.debug.reqMgr.RequestManager;
import com.ist.debug.reqMgr.RequestMediator;
import com.ist.debug.support.Reply;
import com.militsa.tools.BitManipulation;

public class ReferenceFieldsRequestManager
extends RequestManager {
    private int refId;

    public ReferenceFieldsRequestManager(RequestMediator mediator) {
        super(mediator);
    }

    public void manageRequest(int requestId, int length, byte[][] buffers) {
        byte[] buf = buffers[1];
        this.refId = BitManipulation.getInt(buf, 0, true) - 1;
        int nbFields = EventAndRequestState.getNbFieldsLocally(this.refId);
        Reply reply = new Reply(buffers, requestId);
        if (nbFields != -1) {
            reply.putInt(nbFields);
            int i = 0;
            while (i < nbFields) {
                reply.putInt(this.refId + 1);
                reply.putInt(i);
                reply.putBytes(EventAndRequestState.getFieldName(this.refId, i));
                reply.putBytes(EventAndRequestState.getFieldSignature(this.refId, i));
                reply.putInt(EventAndRequestState.getFieldModBits(this.refId, i));
                ++i;
            }
        } else {
            reply.setError((short)25);
        }
        reply.send();
    }

    public String toString() {
        return String.valueOf(super.toString()) + "for type " + this.refId;
    }
}

