/*
 * Decompiled with CFR 0.152.
 */
package com.ist.debug.reqMgr;

import com.ist.debug.EventAndRequestState;
import com.ist.debug.reqMgr.InvokeMethodRequestManager;
import com.ist.debug.reqMgr.RequestMediator;
import com.militsa.tools.BitManipulation;

public class ObjectInvokeMethodRequestManager
extends InvokeMethodRequestManager {
    private static final int OBJECT_ID_OFFSET = 0;
    private static final int THREAD_ID_OFFSET = 4;
    private static final int CLASS_ID_OFFSET = 12;
    private static final int METHOD_ID_OFFSET = 16;
    private static final int NO_ARGUMENTS_OFFSET = 20;
    private static final int ARGUMENTS_OFFSET = 24;

    public ObjectInvokeMethodRequestManager(RequestMediator mediator) {
        super(mediator);
    }

    public int getObjectID(byte[] buf) {
        return BitManipulation.getInt(buf, 0, true);
    }

    public int getThreadID(byte[] buf) {
        return BitManipulation.getInt(buf, 4, true);
    }

    public int getClassID(byte[] buf) {
        return BitManipulation.getInt(buf, 12, true) - 1;
    }

    public int getMethodID(byte[] buf) {
        return BitManipulation.getInt(buf, 16, true);
    }

    public int getNbArguments(byte[] buf) {
        return BitManipulation.getInt(buf, 20, true);
    }

    public int getArgumentsOffset() {
        return 24;
    }

    public String toString() {
        byte[] buf = EventAndRequestState.getMethodSignature(this.classID, this.methodID);
        String sign = new String(buf, 0, buf.length);
        buf = EventAndRequestState.getMethodName(this.classID, this.methodID);
        String name = new String(buf, 0, buf.length);
        buf = EventAndRequestState.getTypeSignatureByTypeID(this.classID);
        String typeName = new String(buf, 1, buf.length - 1);
        return String.valueOf(super.toString()) + "on objectID " + this.objectID + ": " + typeName + name + sign;
    }
}

