/*
 * Decompiled with CFR 0.152.
 */
package com.ist.debug.reqMgr;

import com.ist.debug.EventAndRequestState;
import com.ist.debug.reqMgr.RequestManager;
import com.ist.debug.reqMgr.RequestMediator;
import com.ist.debug.support.Reply;
import com.militsa.tools.BitManipulation;
import jdwp.Value;

public class ObjectGetValuesRequestManager
extends RequestManager {
    private int objectId;

    public ObjectGetValuesRequestManager(RequestMediator mediator) {
        super(mediator);
    }

    public void manageRequest(int requestId, int length, byte[][] buffers) {
        byte[] buf = buffers[1];
        int off = 0;
        this.objectId = BitManipulation.getInt(buf, off, true);
        int noFields = BitManipulation.getInt(buf, off += 4, true);
        off += 4;
        int[] result = new int[3];
        Value[] values = new Value[noFields];
        Reply reply = new Reply(buffers, requestId);
        int i = 0;
        while (i < noFields) {
            int classID = BitManipulation.getInt(buf, off, true) - 1;
            int fieldIndex = BitManipulation.getInt(buf, off += 4, true);
            off += 4;
            int status = EventAndRequestState.getFieldValue(this.objectId, classID, fieldIndex, result);
            if (status < 0) {
                switch (status) {
                    case -4: {
                        reply.setError((short)20);
                        break;
                    }
                    case -3: {
                        System.out.println("Internal error in request manager 9.2: errorcode = -3 (field " + i + ")");
                    }
                    case -2: {
                        reply.setError((short)20);
                        break;
                    }
                    case -1: {
                        reply.setError((short)25);
                    }
                }
                noFields = 0;
                break;
            }
            long data = (long)result[1] << 32 | (long)result[2] & 0xFFFFFFFFL;
            values[i] = new Value((byte)result[0], data);
            ++i;
        }
        reply.putInt(noFields);
        i = 0;
        while (i < noFields) {
            values[i].put(reply, true);
            ++i;
        }
        reply.send();
    }

    public String toString() {
        return String.valueOf(super.toString()) + "for objectID " + this.objectId;
    }
}

