/*
 * Decompiled with CFR 0.152.
 */
package com.ist.debug.reqMgr;

import com.ist.debug.EventAndRequestState;
import com.ist.debug.reqMgr.RequestManager;
import com.ist.debug.reqMgr.RequestMediator;
import com.ist.debug.support.Reply;
import com.militsa.tools.BitManipulation;
import jdwp.Misc;
import jdwp.MiscSizes;

public class MethodVariableTableRequestManager
extends RequestManager
implements Misc,
MiscSizes {
    private int refTypeId;
    private int methodId;

    public MethodVariableTableRequestManager(RequestMediator mediator) {
        super(mediator);
    }

    public void manageRequest(int requestId, int length, byte[][] buffers) {
        byte[] buf = buffers[1];
        this.refTypeId = BitManipulation.getInt(buf, 4, true) - 1;
        int off = 8;
        this.methodId = BitManipulation.getInt(buf, off, true);
        int[] slotsAndArgs = EventAndRequestState.getSlotsAndArgsInfosByMethod(this.refTypeId, this.methodId);
        Reply reply = new Reply(buffers, requestId);
        reply.putInt(slotsAndArgs[0]);
        reply.putInt(slotsAndArgs[1]);
        long[] vars = EventAndRequestState.variableTable(this.refTypeId, this.methodId);
        if (vars != null) {
            int i = 0;
            while (i < vars.length) {
                reply.putLong(vars[i]);
                String name = EventAndRequestState.getInternalName((int)vars[i + 1]);
                reply.putString(name);
                String descriptor = EventAndRequestState.getInternalName((int)vars[i + 2]);
                reply.putString(descriptor);
                reply.putInt((int)vars[i + 3]);
                reply.putInt((int)vars[i + 4]);
                i += 5;
            }
        } else {
            reply.setError((short)23);
        }
        reply.send();
    }

    public String toString() {
        return String.valueOf(super.toString()) + " for method " + this.methodId + " in type " + this.refTypeId;
    }
}

