/*
 * Decompiled with CFR 0.152.
 */
package com.ist.debug.reqMgr;

import com.ist.debug.EventAndRequestState;
import com.ist.debug.reqMgr.RequestManager;
import com.ist.debug.reqMgr.RequestMediator;
import com.ist.debug.support.Reply;
import com.militsa.tools.BitManipulation;

public class MethodLineTableRequestManager
extends RequestManager {
    private int refTypeId;
    private int methodId;

    public MethodLineTableRequestManager(RequestMediator mediator) {
        super(mediator);
    }

    public void manageRequest(int requestId, int length, byte[][] buffers) {
        byte[] buf = buffers[1];
        int off = 4;
        int refTypeID = BitManipulation.getInt(buf, off, true) - 1;
        int methodID = BitManipulation.getInt(buf, off + 4, true);
        off += 8;
        Reply reply = new Reply(buffers, requestId);
        int nbLines = EventAndRequestState.nbLines(refTypeID, methodID);
        if (nbLines == -1) {
            reply.setError((short)23);
        } else if (nbLines == -2) {
            reply.putLong(-1L);
            reply.putLong(-1L);
            reply.putInt(0);
        } else {
            int tabLen = nbLines * 2 + 2;
            long[] lines = new long[tabLen];
            EventAndRequestState.lineTable(refTypeID, methodID, lines);
            reply.putLong(lines[0]);
            reply.putLong(lines[1]);
            reply.putInt(nbLines);
            off = 20;
            int i = 1;
            while (++i < tabLen) {
                reply.putLong(lines[i++]);
                reply.putInt((int)lines[i]);
            }
        }
        reply.send();
    }

    public String toString() {
        String s = new String(EventAndRequestState.getTypeSignatureByTypeID(this.refTypeId));
        return String.valueOf(super.toString()) + "for method " + this.methodId + " declared in class " + s;
    }
}

