/*
 * Decompiled with CFR 0.152.
 */
package com.ist.debug.reqMgr;

import com.ist.debug.DebugThread;
import com.ist.debug.EventAndRequestState;
import com.ist.debug.reqMgr.RequestManager;
import com.ist.debug.reqMgr.RequestMediator;
import com.ist.debug.support.Reply;
import jdwp.Value;

public abstract class InvokeMethodRequestManager
extends RequestManager
implements Runnable {
    public static final int INVOKE_METHOD_TIMEOUT = 3000;
    public byte[][] bufs;
    protected Reply reply;
    public int reqID;
    public int objectID;
    public int threadID;
    public int classID;
    public int methodID;
    public byte[] args;

    public InvokeMethodRequestManager(RequestMediator mediator) {
        super(mediator);
    }

    public abstract int getObjectID(byte[] var1);

    public abstract int getThreadID(byte[] var1);

    public abstract int getClassID(byte[] var1);

    public abstract int getMethodID(byte[] var1);

    public abstract int getNbArguments(byte[] var1);

    public abstract int getArgumentsOffset();

    public final void manageRequest(int requestId, int length, byte[][] buffers) {
        byte[] buf = buffers[1];
        this.reqID = requestId;
        this.objectID = this.getObjectID(buf);
        this.threadID = this.getThreadID(buf);
        this.classID = this.getClassID(buf);
        this.methodID = this.getMethodID(buf);
        this.reply = new Reply(buffers, requestId);
        int noArguments = this.getNbArguments(buf);
        Value[] arguments = new Value[noArguments];
        int off = this.getArgumentsOffset();
        int argsSize = 0;
        int i = 0;
        while (i < noArguments) {
            arguments[i] = new Value();
            off = Value.get(arguments[i], buf, off);
            argsSize += arguments[i].size();
            ++i;
        }
        byte[] args = new byte[argsSize];
        off = 0;
        int i2 = 0;
        while (i2 < noArguments) {
            arguments[i2].put(args, off, true);
            ++i2;
        }
        this.args = args;
        Thread invoker = new Thread((Runnable)this, "invoker");
        DebugThread.setDebugThread(invoker, 1);
        int threadPriority = EventAndRequestState.getThreadPriority(this.threadID);
        if (threadPriority == -1) {
            this.reply.setError((short)10);
            this.reply.send();
            return;
        }
        invoker.setPriority(threadPriority);
        invoker.start();
        try {
            RequestManager.lock.wait(3000L);
        }
        catch (InterruptedException interruptedException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        long[] ret = new long[2];
        short error = 0;
        byte retTag = (byte)EventAndRequestState.invokeMethod(this.objectID, this.threadID, this.classID, this.methodID, this.args, ret);
        if (retTag < 0) {
            ret[0] = 0L;
            switch (retTag) {
                case -1: {
                    error = 20;
                    break;
                }
                case -2: {
                    error = 21;
                    break;
                }
                case -3: {
                    error = 23;
                    break;
                }
                case -4: {
                    error = 10;
                    break;
                }
                case -5: {
                    error = 13;
                    break;
                }
                case -6: {
                    error = 65;
                    break;
                }
                case -7: {
                    error = 110;
                    break;
                }
                case -8: {
                    error = 103;
                }
            }
        }
        long value = ret[0];
        int exception = (int)ret[1];
        Object object = RequestManager.lock;
        synchronized (object) {
            if (retTag >= 0) {
                this.reply.putByte(retTag);
                new Value(retTag, value).put(this.reply, false);
                this.reply.putByte((byte)76);
                this.reply.putInt(0);
            } else if (exception != 0) {
                this.reply.putByte((byte)0);
                new Value(0, 0L).put(this.reply, false);
                this.reply.putByte((byte)76);
                this.reply.putInt(exception);
            }
            this.reply.setError(error);
            this.reply.send();
            RequestManager.lock.notifyAll();
        }
    }
}

